/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;

public class DTDGenerator {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java nu.xom.samples.DTDGenerator URL");
            return;
        }
        try {
            Builder builder = new Builder((NodeFactory)new NamingNodeFactory());
            builder.build(stringArray[0]);
        }
        catch (IOException iOException) {
            System.err.println("Could not read " + stringArray[0] + " due to " + iOException.getMessage());
        }
        catch (ParsingException parsingException) {
            System.err.println(stringArray[0] + " is not well-formed");
        }
    }

    private static class NamingNodeFactory
    extends NodeFactory {
        private List names = new ArrayList();
        private String currentElement;

        private NamingNodeFactory() {
        }

        public Element startMakingElement(String string, String string2) {
            if (!this.names.contains(string)) {
                System.out.println("<!ELEMENT " + string + " ANY>");
                this.names.add(string);
            }
            this.currentElement = string;
            return super.startMakingElement(string, string2);
        }

        public Nodes makeAttribute(String string, String string2, String string3, Attribute.Type type) {
            String string4;
            if (type.equals((Object)Attribute.Type.ENUMERATION) || type.equals((Object)Attribute.Type.UNDECLARED)) {
                type = Attribute.Type.CDATA;
            }
            if (!this.names.contains(string4 = this.currentElement + '#' + string)) {
                this.names.add(string4);
                System.out.println("<!ATTLIST " + this.currentElement + " " + string + " " + type.getName() + " #IMPLIED>");
            }
            return super.makeAttribute(string, string2, string3, type);
        }
    }
}

