/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.benchmarks;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Namespace;
import nu.xom.Nodes;
import nu.xom.ParsingException;

class NamespaceLister {
    NamespaceLister() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.benchmarks.NamespaceLister URL");
            return;
        }
        NamespaceLister namespaceLister = new NamespaceLister();
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            NamespaceLister.bench(namespaceLister, document);
            long l = 0L;
            int n = 100;
            for (int i = 1; i < n; ++i) {
                l += NamespaceLister.bench(namespaceLister, document);
            }
            System.out.println((double)l / (double)n + "ms to list all URIs on average");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
    }

    private static long bench(NamespaceLister namespaceLister, Document document) {
        long l = System.currentTimeMillis();
        namespaceLister.list(document.getRootElement());
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    private void list(Element element) {
        this.getDeclaredNamepaces(element);
        this.getInscopeNamespaces(element);
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            this.list(elements.get(i));
        }
    }

    private void getDeclaredNamepaces(Element element) {
        for (int i = element.getNamespaceDeclarationCount() - 1; i >= 0; --i) {
            String string = element.getNamespacePrefix(i);
            System.out.println(element.getNamespaceURI(string));
        }
    }

    private void getInscopeNamespaces(Element element) {
        Nodes nodes = element.query("namespace::node()");
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Namespace namespace = (Namespace)nodes.get(i);
            System.out.println(namespace.getValue());
        }
    }
}

