/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class XHTMLPurifier {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.XHTMLPurifier URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            if (!element.getNamespaceURI().equals(XHTML_NAMESPACE)) {
                System.out.println(stringArray[0] + " does not appear to be an XHTML document");
                return;
            }
            XHTMLPurifier.strip(element);
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }

    public static void strip(Element element) {
        if (element.getNamespaceURI().equals(XHTML_NAMESPACE)) {
            Object object;
            int n;
            for (n = 0; n < element.getAttributeCount(); ++n) {
                object = element.getAttribute(n);
                if ("".equals(object.getNamespaceURI()) || "xml".equals(object.getNamespacePrefix())) continue;
                object.detach();
            }
            for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
                object = element.getNamespacePrefix(n);
                element.removeNamespaceDeclaration((String)object);
            }
            Elements elements = element.getChildElements();
            for (int i = 0; i < elements.size(); ++i) {
                XHTMLPurifier.strip(elements.get(i));
            }
        } else {
            element.detach();
        }
    }
}

