/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;

public class ResourceToTable {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String RDDL_NAMESPACE = "http://www.rddl.org/";
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.ResourceToTable URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            if (!element.getNamespaceURI().equals(XHTML_NAMESPACE)) {
                System.out.println(stringArray[0] + " does not appear to be an XHTML document");
                return;
            }
            ResourceToTable.convert(element);
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }

    public static void convert(Element element) {
        if (element.getNamespaceURI().equals(RDDL_NAMESPACE)) {
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            Element element6;
            Attribute attribute;
            Element element7 = new Element("table", XHTML_NAMESPACE);
            Attribute attribute2 = element.getAttribute("role", XLINK_NAMESPACE);
            if (attribute2 != null) {
                attribute = new Element("tr", XHTML_NAMESPACE);
                element6 = new Element("td", XHTML_NAMESPACE);
                attribute.appendChild((Node)element6);
                element6.appendChild("Role: ");
                element5 = new Element("td", XHTML_NAMESPACE);
                attribute.appendChild((Node)element5);
                element5.appendChild(attribute2.getValue());
                element7.insertChild((Node)attribute, 0);
            }
            if ((attribute = element.getAttribute("arcrole", XLINK_NAMESPACE)) != null) {
                element6 = new Element("tr", XHTML_NAMESPACE);
                element5 = new Element("td", XHTML_NAMESPACE);
                element6.appendChild((Node)element5);
                element5.appendChild("Arcrole: ");
                element4 = new Element("td", XHTML_NAMESPACE);
                element6.appendChild((Node)element4);
                element4.appendChild(attribute.getValue());
                element7.insertChild((Node)element6, 0);
            }
            if ((element6 = element.getAttribute("href", XLINK_NAMESPACE)) != null) {
                element5 = new Element("tr", XHTML_NAMESPACE);
                element4 = new Element("td", XHTML_NAMESPACE);
                element5.appendChild((Node)element4);
                element4.appendChild("Href: ");
                element3 = new Element("td", XHTML_NAMESPACE);
                element5.appendChild((Node)element3);
                element2 = new Element("a", XHTML_NAMESPACE);
                element2.appendChild(element6.getValue());
                element3.appendChild((Node)element2);
                element2.addAttribute(new Attribute("href", element6.getValue()));
                element7.insertChild((Node)element5, 0);
            }
            if ((element5 = element.getAttribute("title", XLINK_NAMESPACE)) != null) {
                element4 = new Element("caption", XHTML_NAMESPACE);
                element4.appendChild(element5.getValue());
                element7.insertChild((Node)element4, 0);
            }
            element4 = new Element("tr", XHTML_NAMESPACE);
            element3 = new Element("td", XHTML_NAMESPACE);
            element3.addAttribute(new Attribute("colspan", "2"));
            element4.appendChild((Node)element3);
            while (element.getChildCount() > 0) {
                element2 = element.getChild(0);
                element2.detach();
                element3.appendChild((Node)element2);
                if (!(element2 instanceof Element)) continue;
                ResourceToTable.convert(element2);
            }
            element7.appendChild((Node)element4);
            element2 = element.getParent();
            element2.replaceChild((Node)element, (Node)element7);
        } else {
            for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
                String string = element.getNamespacePrefix(i);
                element.removeNamespaceDeclaration(string);
            }
            Elements elements = element.getChildElements();
            for (int i = 0; i < elements.size(); ++i) {
                ResourceToTable.convert(elements.get(i));
            }
        }
    }
}

