/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.WellformednessException;

public class FibonacciXOMSOAPServlet
extends HttpServlet
implements SingleThreadModel {
    public static final String MALFORMED_REQUEST_DOCUMENT = "MalformedRequest";
    public static final String INVALID_REQUEST_DOCUMENT = "InvalidRequest";
    public static final String INDEX_MISSING = "IndexMissing";
    public static final String NON_POSITIVE_INDEX = "NonPositiveIndex";
    public static final String BAD_INTEGER_FORMAT = "BadIntegerFormat";
    public static final String UNEXPECTED_PROBLEM = "UnexpectedProblem";
    private transient Builder parser;

    public void init() throws ServletException {
        try {
            this.parser = new Builder();
        }
        catch (Exception exception) {
            throw new ServletException("Could not locate a XOM parser", (Throwable)exception);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Document document;
        httpServletResponse.setContentType("application/soap+xml; charset=UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8");
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        String string = "here";
        try {
            Document document2 = this.parser.build((InputStream)servletInputStream);
            string = document2.getValue().trim();
            int n = Integer.parseInt(string);
            BigInteger bigInteger = FibonacciXOMSOAPServlet.calculateFibonacci(n);
            document = this.makeResponseDocument(bigInteger);
        }
        catch (WellformednessException wellformednessException) {
            document = this.makeFaultDocument(MALFORMED_REQUEST_DOCUMENT, wellformednessException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            document = this.makeFaultDocument(INDEX_MISSING, nullPointerException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            document = this.makeFaultDocument(BAD_INTEGER_FORMAT, string + numberFormatException.getMessage());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            document = this.makeFaultDocument(NON_POSITIVE_INDEX, indexOutOfBoundsException.getMessage());
        }
        catch (Exception exception) {
            document = this.makeFaultDocument(UNEXPECTED_PROBLEM, exception.getMessage());
        }
        try {
            outputStreamWriter.write(document.toXML());
            httpServletResponse.flushBuffer();
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
        finally {
            servletInputStream.close();
            outputStreamWriter.close();
        }
    }

    public Document makeResponseDocument(BigInteger bigInteger) {
        Element element = new Element("SOAP-ENV:Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
        Document document = new Document(element);
        Element element2 = new Element("SOAP-ENV:Body", "http://schemas.xmlsoap.org/soap/envelope/");
        element.appendChild((Node)element2);
        Element element3 = new Element("Fibonacci_Numbers", "http://namespaces.cafeconleche.org/xmljava/ch3/");
        element2.appendChild((Node)element3);
        Element element4 = new Element("fibonacci", "http://namespaces.cafeconleche.org/xmljava/ch3/");
        element3.appendChild((Node)element4);
        element4.appendChild(bigInteger.toString());
        return document;
    }

    public Document makeFaultDocument(String string, String string2) {
        Element element = new Element("SOAP-ENV:Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
        Document document = new Document(element);
        Element element2 = new Element("SOAP-ENV:Body", "http://schemas.xmlsoap.org/soap/envelope/");
        element.appendChild((Node)element2);
        Element element3 = new Element("Fault", "http://schemas.xmlsoap.org/soap/envelope/");
        element2.appendChild((Node)element3);
        Element element4 = new Element("faultcode");
        element3.appendChild((Node)element4);
        Element element5 = new Element("faultstring");
        element3.appendChild((Node)element5);
        element4.appendChild(string);
        element5.appendChild(string2);
        return document;
    }

    public static BigInteger calculateFibonacci(int n) throws IndexOutOfBoundsException {
        if (n < 1) {
            throw new IndexOutOfBoundsException("Fibonacci numbers are not defined for " + n + "or any other number less than one.");
        }
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = BigInteger.ONE;
        for (int i = 2; i <= n; ++i) {
            BigInteger bigInteger3 = bigInteger2;
            bigInteger2 = bigInteger2.add(bigInteger);
            bigInteger = bigInteger3;
        }
        return bigInteger;
    }
}

