/* Fo
 * fo-area-private.h: Structures and functions private to base area object
 *
 * Copyright (C) 2001-2006 Sun Microsystems
 * Copyright (C) 2007-2010 Menteith Consulting Ltd
 *
 * See COPYING for the status of this software.
 */

#ifndef __FO_AREA_PRIVATE_H__
#define __FO_AREA_PRIVATE_H__

#include <libfo/datatype/fo-all-datatype.h>
#include <libfo/fo-node-private.h>
#include <libfo/area/fo-area.h>
#include <libfo/fo/fo-fo.h>

G_BEGIN_DECLS

struct _FoArea
{
  FoNode parent_instance;

  FoAreaFlagsClass class;  /* XSL area-class trait */
  FoArea  *page_sequence;
  FoArea  *page;
  FoArea  *reference;
  gboolean is_first;       /* First area generated by 'generated_by'? */
  FoArea  *prev_part;      /* Previous area generated by 'generated_by' */
  gboolean is_last;        /* Last area generated by 'generated_by'? */
  FoArea  *next_part;      /* Next area generated by 'generated_by' */

  gdouble next_x;           /* X-offset at which to place next child */
  gdouble next_y;           /* Y-offset at which to place next child */
  gdouble available_width;  /* Width available to this area */
  gdouble available_height; /* Height available to this area */
  gdouble child_available_ipdim;  /* bpdim available to children of this area */
  gdouble child_available_bpdim; /* ipdim available to children of this area */

  FoFo *generated_by;
};

struct _FoAreaClass
{
  FoNodeClass parent_class;

  void     (* draw)                      (FoArea   *area,
					  gpointer output);
  void     (* debug_dump_properties)     (FoArea *area,
					  gint    depth);
  FoArea*  (* add_child)                 (FoArea *parent,
					  FoArea *child);
  FoArea*  (* clone)                     (FoArea *original);
  void     (* update_after_clone)        (FoArea *clone,
					  FoArea *original);
  FoArea*  (* split_before_height)       (FoArea *area,
					  gdouble  height);
  gboolean (* split_before_height_check) (FoArea *area,
					  gdouble  height);
  FoArea*  (* split_after_height)        (FoArea *area,
					  gdouble  height);
  gboolean (* split_after_height_check)  (FoArea *area,
					  gdouble  height);
  FoArea*  (* size_request)              (FoArea *child);
  void     (* resolve_text_align)        (FoArea *area);

  /* tree functions that may be restricted */
  FoArea*  (* insert)                    (FoArea *parent,
					  gint    position,
					  FoArea *area);
  FoArea*  (* insert_before)	         (FoArea *parent,
					  FoArea *sibling,
					  FoArea *area);
  FoArea*  (* insert_after)              (FoArea *parent,
					  FoArea *sibling,
					  FoArea *area); 
  FoArea*  (* prepend)		         (FoArea *parent,
					  FoArea *area);
  FoArea*  (* append)                    (FoArea *parent,
					  FoArea *area);
  FoNodeTraverseFunc release;
};

FoArea * fo_area_real_add_child (FoArea  *parent,
				 FoArea  *child);

gboolean   fo_area_release (FoNode  *fo_node,
			  gpointer data);

/* utility functions for fo_area_children_foreach */
void fo_area_accumulate_height (FoArea *area,
				gpointer data);
void fo_area_size_adjust (FoArea *area,
			  gpointer data);
void fo_area_set_or_split (FoArea *area,
			   gpointer data);

G_END_DECLS

#endif /* !__FO_AREA_PRIVATE_H__ */
