<?xml version="1.0" encoding="utf-8"?>
<!-- libfo -->
<!-- xmlroff-property-object-decl-dump.xsl -->
<!-- Read the XSL spec and dump xmlroff-property-decl.ent file -->

<!-- Copyright (C) 2001-2006 Sun Microsystems -->
<!-- Copyright (C) 2007-2010 Menteith Consulting Ltd -->
<!-- Copyright (C) 2011 Mentea -->
<!-- See COPYING for the status of this software. -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="exsl"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:include href="conversion-lib.xsl"/>

  <xsl:param name="codegen-info"/>
  <xsl:param name="debug"/>

  <xsl:variable name="codegen-info-doc" select="document($codegen-info)"/>

  <xsl:variable name="all-properties"
    select="/spec/back/div1[@id='property-index']/div2[@id = 'prtab1']
            /table/tbody/tr/td[@class = 'propindex']/specref/@ref"/>

  <xsl:variable name="allowed-properties"
    select="document($codegen-info)/codegen-info/properties/property/@name"/>

  <xsl:template name="property-to-property-entity-decl">
    <xsl:param name="property"/>

    <xsl:text>&lt;!ENTITY fo-property-</xsl:text>
    <xsl:value-of select="$property"/>
    <xsl:text> SYSTEM "xml/fo-property-</xsl:text>
    <xsl:value-of select="$property"/>
    <xsl:text>.xml">&#10;</xsl:text>
  </xsl:template>

  <!-- xmlroff-property-decl-ent-file -->
  <!-- Generate the xmlroff-property-decl.ent file -->
  <xsl:template name="xmlroff-property-decl-ent-file">
    <xsl:param name="properties"/>

    <exsl:document href="./xmlroff-property-decl.ent"
      method="text">

      <xsl:text>&lt;!-- This file is autogenerated. Do not edit -->&#10;</xsl:text>

      <xsl:text>&lt;!ENTITY fo-property SYSTEM "xml/fo-property.xml">&#10;</xsl:text>

      <xsl:for-each select="$properties">
        <xsl:variable name="property" select="."/>

        <xsl:call-template name="property-to-property-entity-decl">
          <xsl:with-param name="property" select="."/>
        </xsl:call-template>

        <xsl:choose>
          <xsl:when
            test="$allowed-properties[. = $property][../@type = 'keep']">
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-within-column<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-within-line<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-within-page<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when
            test="$allowed-properties[. = $property][../@type = 'space' or ../@type = 'length-range']">
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-minimum<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-optimum<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="property-to-property-entity-decl">
              <xsl:with-param name="property">
                <xsl:value-of select="."/>-maximum<xsl:text/>
              </xsl:with-param>
            </xsl:call-template>

            <xsl:if
              test="$allowed-properties[. = $property][../@type = 'space']"
>
              <xsl:call-template name="property-to-property-entity-decl">
                <xsl:with-param name="property">
                  <xsl:value-of select="."/>-conditionality<xsl:text/>
                </xsl:with-param>
              </xsl:call-template>
              <xsl:call-template name="property-to-property-entity-decl">
                <xsl:with-param name="property">
                  <xsl:value-of select="."/>-precedence<xsl:text/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:if>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>

      <xsl:text>&lt;!ENTITY fo-property-util SYSTEM "xml/fo-property-util.xml">&#10;</xsl:text>
    </exsl:document>
  </xsl:template>

  <xsl:template match="/">
    <xsl:variable name="properties"
      select="$all-properties
              [not($allowed-properties) or $allowed-properties = .]"/>

    <xsl:if test="$debug">
      <xsl:for-each select="$properties">
        <xsl:message><xsl:value-of select="."/></xsl:message>
      </xsl:for-each>
    </xsl:if>

    <xsl:if test="not($codegen-info) or $properties">
      <xsl:call-template name="xmlroff-property-decl-ent-file">
        <xsl:with-param name="properties" select="$properties"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
