/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xfancy.c                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : fancy routines                                           *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcFillGdkColor()      - Fill the GdkColor widget       *
 *                XMdcMakeMyColors()      - Make my prefered colors        *
 *                XMdcMakeMyFonts()       - Make my prefered fonts         *
 *                XMdcMakeMyCursors()     - Make my prefered cursors       *
 *                XMdcFreeMyStuff()       - Free my prefered stuff         *
 *                XMdcAbout()             - Hello                          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id$
 */

/*
   Copyright (C) 1997-2019 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#ifndef _WIN32
#include <strings.h>
#endif
#endif

#include "xmedcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcFillGdkColor(GdkColor *color, gint red, gint green, gint blue)
{
  /* red, green, and blue are passed values, indicating the RGB triple
   * of the color we want to draw. Note that the values of the RGB components
   * within the GdkColor are taken from 0 to 65535, not 0 to 255.
   */

  color->red   = red   * (65535/255);
  color->green = green * (65535/255);
  color->blue  = blue  * (65535/255);

  /* the pixel value indicates the index in the colormap of the color.
   * it is simply a combination of the RGB values we set earlier
   */

  color->pixel = (gulong)(red*65536 + green*256 + blue);

  /* However, the pixel valule is only truly valid on 24-bit (TrueColor)
   * displays. Therefore, this call is required so that GDK and X can
   * give us the closest color available in the colormap
   */
}

void XMdcMakeMyColors(void)
{
  XMdcFillGdkColor(&Red,255,0,0);
  XMdcFillGdkColor(&Green,0,255,0);
  XMdcFillGdkColor(&Blue,0,0,255);
  XMdcFillGdkColor(&Yellow,255,255,0);
}

void XMdcMakeMyFonts(void)
{
#ifdef _WIN32
sfixed=gdk_font_load("-*-courier new-medium-r-normal--*-100-*-*-*-*-iso8859-1");
#else
sfixed=gdk_font_load("-*-fixed-medium-r-semicondensed-*-*-120-*-*-*-*-*");
 if (sfixed == NULL)
sfixed=gdk_font_load("-adobe-courier-medium-r-normal-*-*-100-*-*-*-*-*-*");
 if (sfixed == NULL)
sfixed=gdk_font_load("-misc-fixed-medium-r-normal--*-100-*-*-*-*-*-*");
#endif
 if (sfixed == NULL) {
   XMdcDisplayErr("Couldn't get fixed font");
#ifdef GTKONE
   sfixed = my.mainwindow->style->font;
#else
   /* the below is deprecated... should really be using pango fonts */
   sfixed = gtk_style_get_font(my.mainwindow->style);
#endif
 }
}

void XMdcMakeMyCursors(void)
{
  handcursor  = gdk_cursor_new(GDK_HAND2);
  fleurcursor = gdk_cursor_new(GDK_FLEUR);

  if (handcursor == NULL || fleurcursor == NULL)
    XMdcDisplayErr("Couldn't get cursor types");

}

void XMdcFreeMyStuff(void)
{
  /* the cursors */
  if (handcursor != NULL) gdk_cursor_destroy(handcursor);
  if (fleurcursor != NULL) gdk_cursor_destroy(fleurcursor);

  /* the fonts */
  if (sfixed != NULL) gdk_font_unref(sfixed);

}

void XMdcAbout(GtkWidget *widget, gpointer data)
{
  GtkWidget *window=NULL;
  GtkWidget *box1;
  GtkWidget *label;
  GtkWidget *button;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(window),"destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);
  gtk_window_set_title(GTK_WINDOW(window),"Hello There");

  gtk_container_set_border_width(GTK_CONTAINER(window), 0);

  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window),box1);
  gtk_widget_show(box1);

  sprintf(mdcbufr," %s \n\n",MdcGetLibLongVersion());
  strcat(mdcbufr," http://xmedcon.sourceforge.net \n\n" \
                 " With special regards to You \n\n" \
                 " Licensed  by  Murphy's Law \n" \
                 " Enjoy it ...");
  label = gtk_label_new(mdcbufr);
  gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(box1),label,TRUE,TRUE,5);
  gtk_widget_show(label);

  button = gtk_button_new_with_label("Bye");
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy),
                     GTK_OBJECT(window));
  gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,5);
  gtk_widget_show(button);

  XMdcShowWidget(window);

}

