/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xalan.xpath.xml.BoolStack;
import org.apache.xalan.xpath.xml.RawCharacterHandler;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xml.serialize.OutputFormat;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FormatterToXML
implements DocumentHandler,
LexicalHandler,
RawCharacterHandler {
    protected Writer m_writer = null;
    boolean m_shouldFlush = true;
    protected OutputStream m_outputStream = null;
    private boolean m_bytesEqualChars = false;
    public boolean m_stripCData = false;
    public boolean m_escapeCData = false;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected final String m_lineSep = System.getProperty("line.separator");
    protected final int m_lineSepLen = this.m_lineSep.length();
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int indent = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    boolean m_nextIsRaw = false;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone = false;
    String m_mediatype;
    protected boolean m_inEntityRef = false;
    public char[] m_attrSpecialChars = new char[]{'<', '>', '&', '\"'};
    static final int SPECIALSSIZE = 256;
    public char[] m_attrCharsMap = new char[256];
    public char[] m_charsMap = new char[256];
    boolean m_isUTF8;
    char m_maxCharacter = (char)127;
    public boolean m_spaceBeforeClose = false;
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    protected boolean m_inCData = false;
    static final int MAXCHARBUF = 8192;
    protected char[] m_charBuf = new char[8192];
    protected byte[] m_byteBuf = new byte[8192];
    protected int m_pos = 0;
    private static Hashtable s_enchash = null;
    private static Hashtable s_revhash = null;
    protected static Hashtable s_revsize = new Hashtable();

    public FormatterToXML() {
        FormatterToXML.initEncodings();
    }

    public FormatterToXML(OutputStream outputStream) throws UnsupportedEncodingException {
        FormatterToXML.initEncodings();
        this.init(outputStream, new OutputFormat("xml", DEFAULT_MIME_ENCODING, false));
    }

    public FormatterToXML(Writer writer) {
        this.m_shouldFlush = false;
        this.m_writer = writer;
        FormatterToXML.initEncodings();
    }

    public FormatterToXML(FormatterToXML formatterToXML) {
        this.m_writer = formatterToXML.m_writer;
        this.m_outputStream = formatterToXML.m_outputStream;
        this.m_bytesEqualChars = formatterToXML.m_bytesEqualChars;
        this.m_stripCData = formatterToXML.m_stripCData;
        this.m_escapeCData = formatterToXML.m_escapeCData;
        this.m_encoding = formatterToXML.m_encoding;
        this.m_shouldNotWriteXMLHeader = formatterToXML.m_shouldNotWriteXMLHeader;
        this.m_shouldNotWriteXMLHeader = formatterToXML.m_shouldNotWriteXMLHeader;
        this.m_elemStack = formatterToXML.m_elemStack;
        this.m_ispreserve = formatterToXML.m_ispreserve;
        this.m_preserves = formatterToXML.m_preserves;
        this.m_isprevtext = formatterToXML.m_isprevtext;
        this.m_doIndent = formatterToXML.m_doIndent;
        this.m_currentIndent = formatterToXML.m_currentIndent;
        this.indent = formatterToXML.indent;
        this.level = formatterToXML.level;
        this.m_startNewLine = formatterToXML.m_startNewLine;
        this.m_needToOutputDocTypeDecl = formatterToXML.m_needToOutputDocTypeDecl;
        this.m_nextIsRaw = formatterToXML.m_nextIsRaw;
        this.m_doctypeSystem = formatterToXML.m_doctypeSystem;
        this.m_doctypePublic = formatterToXML.m_doctypePublic;
        this.m_standalone = formatterToXML.m_standalone;
        this.m_mediatype = formatterToXML.m_mediatype;
        this.m_attrSpecialChars = formatterToXML.m_attrSpecialChars;
        this.m_attrCharsMap = formatterToXML.m_attrCharsMap;
        this.m_charsMap = formatterToXML.m_charsMap;
        this.m_maxCharacter = formatterToXML.m_maxCharacter;
        this.m_spaceBeforeClose = formatterToXML.m_spaceBeforeClose;
        this.m_inCData = formatterToXML.m_inCData;
        this.m_charBuf = formatterToXML.m_charBuf;
        this.m_byteBuf = formatterToXML.m_byteBuf;
        this.m_pos = 0;
        this.initCharsMap();
    }

    protected final void accum(byte by) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = by;
            if (this.m_pos >= 8192) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = (char)by;
            if (this.m_pos >= 8192) {
                this.flushChars();
            }
        }
    }

    protected final void accum(char c) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = (byte)c;
            if (this.m_pos >= 8192) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = c;
            if (this.m_pos >= 8192) {
                this.flushChars();
            }
        }
    }

    protected final void accum(String string) throws SAXException {
        int n = string.length();
        if (this.m_bytesEqualChars) {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < n) {
                this.m_byteBuf[this.m_pos++] = (byte)cArray[n2];
                if (this.m_pos >= 8192) {
                    this.flushBytes();
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.m_charBuf[this.m_pos++] = string.charAt(n3);
                if (this.m_pos >= 8192) {
                    this.flushChars();
                }
                ++n3;
            }
        }
    }

    protected final void accum(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n + n2;
        if (this.m_bytesEqualChars) {
            int n4 = n;
            while (n4 < n3) {
                this.m_byteBuf[this.m_pos++] = (byte)cArray[n4];
                if (this.m_pos >= 8192) {
                    this.flushBytes();
                }
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n3) {
                this.m_charBuf[this.m_pos++] = cArray[n5];
                if (this.m_pos >= 8192) {
                    this.flushChars();
                }
                ++n5;
            }
        }
    }

    final boolean accumDefaultEntity(char c, int n, char[] cArray, int n2, boolean bl) throws SAXException {
        if (!bl && c == '\r' && n + 1 < n2 && cArray[n + 1] == '\n') {
            this.outputLineSep();
            ++n;
        } else if (!bl && c == '\n' && n + 1 < n2 && cArray[n + 1] == '\r') {
            this.outputLineSep();
            ++n;
        } else if (!bl && c == '\r') {
            this.outputLineSep();
            ++n;
        } else if (!bl && c == '\n') {
            this.outputLineSep();
        } else if (c == '<') {
            this.accum('&');
            this.accum('l');
            this.accum('t');
            this.accum(';');
        } else if (c == '>') {
            this.accum('&');
            this.accum('g');
            this.accum('t');
            this.accum(';');
        } else if (c == '&') {
            this.accum('&');
            this.accum('a');
            this.accum('m');
            this.accum('p');
            this.accum(';');
        } else if (c == '\"') {
            this.accum('&');
            this.accum('q');
            this.accum('u');
            this.accum('o');
            this.accum('t');
            this.accum(';');
        } else if (c == '\'') {
            this.accum('&');
            this.accum('a');
            this.accum('p');
            this.accum('o');
            this.accum('s');
            this.accum(';');
        } else {
            return false;
        }
        return true;
    }

    final void accumDefaultEscape(char c, int n, char[] cArray, int n2, boolean bl) throws SAXException {
        if (!this.accumDefaultEntity(c, n, cArray, n2, bl)) {
            if (c >= '\ud800' && c < '\udc00') {
                int n3;
                if (n + 1 >= n2) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
                }
                if ((n3 = cArray[++n]) < 56320 || n3 >= 57344) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n3)}));
                }
                n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
                this.accum("&#");
                this.accum(Integer.toString(n3));
                this.accum(";");
            } else if (c > this.m_maxCharacter || c < '\u0100' && this.m_attrCharsMap[c] == 'S') {
                this.accum("&#");
                this.accum(Integer.toString(c));
                this.accum(";");
            } else {
                this.accum(c);
            }
        }
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.m_nextIsRaw) {
                this.m_nextIsRaw = false;
                this.charactersRaw(cArray, n, n2);
                return;
            }
            if (this.m_escapeCData) {
                this.characters(cArray, n, n2);
            } else {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                if (!this.m_stripCData && n2 >= 1 && cArray[n] <= this.m_maxCharacter) {
                    this.accum("<![CDATA[");
                }
                this.writeNormalizedChars(cArray, n, n2, this.m_stripCData ^ true);
                if (!this.m_stripCData && n2 >= 1 && cArray[n + n2 - 1] <= this.m_maxCharacter) {
                    this.accum("]]>");
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_nextIsRaw) {
            this.m_nextIsRaw = false;
            this.charactersRaw(cArray, n, n2);
            return;
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (c < '\u0100' && this.m_charsMap[c] != 'S') {
                this.accum(c);
            } else {
                this.accumDefaultEscape(c, n4, cArray, n3, false);
            }
            ++n4;
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        this.accum(cArray, n, n2);
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("<!--");
        this.accum(cArray, n, n2);
        this.accum("-->");
        this.m_startNewLine = true;
    }

    public static String convertJava2MimeEncoding(String string) {
        if (s_revhash == null) {
            FormatterToXML.initEncodings();
        }
        if (string == null) {
            return DEFAULT_MIME_ENCODING;
        }
        return javaEncodingIsISO ? string : (String)s_revhash.get(string.toUpperCase());
    }

    public static String convertMime2JavaEncoding(String string) throws UnsupportedEncodingException {
        String string2;
        if (s_enchash == null) {
            FormatterToXML.initEncodings();
        }
        if (string == null) {
            return "UTF8";
        }
        String string3 = string2 = javaEncodingIsISO ? string : (String)s_enchash.get(string.toUpperCase());
        if (string2 == null && FormatterToXML.isSupportedJavaEncoding(string)) {
            string2 = string;
        }
        if (string2 == null) {
            throw new UnsupportedEncodingException(XSLMessages.createXPATHMessage(48, new Object[]{string}));
        }
        return string2;
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flush();
        this.flushWriter();
    }

    public void endElement(String string) throws SAXException {
        this.m_currentIndent -= this.indent;
        boolean bl = this.childNodesWereAdded();
        if (bl) {
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('/');
            this.accum(string);
            this.accum('>');
        } else if (this.m_spaceBeforeClose) {
            this.accum(" />");
        } else {
            this.accum("/>");
        }
        if (bl) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
    }

    public void endEntity(String string) throws SAXException {
        this.m_inEntityRef = false;
    }

    public void entityReference(String string) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("&");
        this.accum(string);
        this.accum(";");
    }

    public final void flush() throws SAXException {
        if (this.m_bytesEqualChars) {
            this.flushBytes();
        } else {
            this.flushChars();
        }
    }

    private final void flushBytes() throws SAXException {
        try {
            this.m_outputStream.write(this.m_byteBuf, 0, this.m_pos);
            this.m_pos = 0;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private final void flushChars() throws SAXException {
        try {
            this.m_writer.write(this.m_charBuf, 0, this.m_pos);
            this.m_pos = 0;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void flushWriter() throws SAXException {
        if (this.m_shouldFlush && this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    String getMimeEncoding(String string) {
        block3: {
            if (string != null) break block3;
            try {
                string = System.getProperty("file.encoding");
                if (string != null) {
                    String string2 = string.equals("Cp1252") || string.equals("ISO8859_1") || string.equals("8859_1") || string.equals("UTF8") ? DEFAULT_MIME_ENCODING : FormatterToXML.convertJava2MimeEncoding(string);
                    string = string2 != null ? string2 : DEFAULT_MIME_ENCODING;
                    break block3;
                }
                string = DEFAULT_MIME_ENCODING;
            }
            catch (SecurityException securityException) {
                string = DEFAULT_MIME_ENCODING;
            }
        }
        return string;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        this.characters(cArray, n, n2);
    }

    public void indent(int n) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n);
        }
    }

    public synchronized void init(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        this.m_encoding = this.getMimeEncoding(outputFormat.getEncoding());
        if (this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.m_bytesEqualChars = true;
            this.m_outputStream = outputStream;
            this.init(null, outputFormat, true);
        } else {
            String string = FormatterToXML.convertMime2JavaEncoding(this.m_encoding);
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
            }
            catch (Exception exception) {
                try {
                    if (string.startsWith("ISO")) {
                        string = string.substring(3);
                        try {
                            outputStreamWriter = new OutputStreamWriter(outputStream, string);
                        }
                        catch (Exception exception2) {
                            outputStreamWriter = new OutputStreamWriter(outputStream, this.m_encoding);
                        }
                    } else {
                        outputStreamWriter = new OutputStreamWriter(outputStream, this.m_encoding);
                    }
                }
                catch (Exception exception3) {
                    System.out.print("Java VM does not support encoding: " + this.m_encoding);
                    if (string != null) {
                        System.out.println(" or " + string);
                    } else {
                        System.out.println();
                    }
                    outputStreamWriter = new OutputStreamWriter(outputStream);
                }
            }
            this.init(outputStreamWriter, outputFormat, true);
        }
    }

    public synchronized void init(Writer writer, OutputFormat outputFormat) {
        this.init(writer, outputFormat, false);
    }

    private synchronized void init(Writer writer, OutputFormat outputFormat, boolean bl) {
        this.m_shouldFlush = bl;
        this.m_writer = writer;
        this.indent = outputFormat.getIndent() - 1;
        this.m_doIndent = outputFormat.getIndenting();
        this.m_shouldNotWriteXMLHeader = outputFormat.getOmitXMLDeclaration();
        this.m_doctypeSystem = outputFormat.getDoctypeSystem();
        this.m_doctypePublic = outputFormat.getDoctypePublic();
        this.m_standalone = outputFormat.getStandalone();
        this.m_mediatype = outputFormat.getMediaType();
        if (this.m_doctypePublic != null && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        this.m_maxCharacter = outputFormat.getLastPrintable();
        this.initCharsMap();
        if (this.m_encoding == null) {
            this.m_encoding = this.getMimeEncoding(outputFormat.getEncoding());
        }
        this.m_isUTF8 = this.m_encoding.equals(DEFAULT_MIME_ENCODING);
        Object v = s_revsize.get(this.m_encoding.toUpperCase());
        if (v != null) {
            Character c = (Character)v;
            this.m_maxCharacter = c.charValue();
            this.initCharsMap();
        }
    }

    protected void initAttrCharsMap() {
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int n2 = 0;
        while (n2 < n) {
            this.m_attrCharsMap[n2] = '\u0000';
            ++n2;
        }
        int n3 = this.m_attrSpecialChars.length;
        int n4 = 0;
        while (n4 < n3) {
            this.m_attrCharsMap[this.m_attrSpecialChars[n4]] = 83;
            ++n4;
        }
        this.m_attrCharsMap[10] = 83;
        this.m_attrCharsMap[13] = 83;
    }

    protected void initCharsMap() {
        this.initAttrCharsMap();
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int n2 = 0;
        while (n2 < n) {
            this.m_charsMap[n2] = '\u0000';
            ++n2;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[60] = 83;
        this.m_charsMap[62] = 83;
        this.m_charsMap[38] = 83;
        int n3 = 0;
        while (n3 < 20) {
            this.m_charsMap[n3] = 83;
            ++n3;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
        this.m_charsMap[9] = '\u0000';
        int n4 = this.m_maxCharacter;
        while (n4 < 256) {
            this.m_charsMap[n4] = 83;
            ++n4;
        }
    }

    public static void initEncodings() {
        Hashtable hashtable = s_revsize;
        synchronized (hashtable) {
            Object object;
            if (s_enchash != null) {
                Object var1_1 = null;
                return;
            }
            boolean bl = true;
            try {
                object = new ByteArrayOutputStream();
                ((ByteArrayOutputStream)object).write(32);
                String string = ((ByteArrayOutputStream)object).toString("ISO8859_1");
                bl = string != null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl = false;
            }
            try {
                String string;
                int n;
                object = System.getProperty("file.encoding");
                int n2 = n = object != null ? ((String)object).indexOf(45) : -1;
                if (n == 3 && (string = new String(((String)object).toCharArray(), 0, 3)).equals("ISO")) {
                    javaEncodingIsISO = true;
                }
            }
            catch (SecurityException securityException) {}
            s_revsize.put("WINDOWS-1250", new Character('\u00ff'));
            s_revsize.put(DEFAULT_MIME_ENCODING, new Character('\uffff'));
            s_revsize.put("US-ASCII", new Character('\u007f'));
            s_revsize.put("ISO-8859-1", new Character('\u00ff'));
            s_revsize.put("ISO-8859-2", new Character('\u00ff'));
            s_revsize.put("ISO-8859-3", new Character('\u00ff'));
            s_revsize.put("ISO-8859-4", new Character('\u00ff'));
            s_revsize.put("ISO-8859-5", new Character('\u00ff'));
            s_revsize.put("ISO-8859-6", new Character('\u00ff'));
            s_revsize.put("ISO-8859-7", new Character('\u00ff'));
            s_revsize.put("ISO-8859-8", new Character('\u00ff'));
            s_revsize.put("ISO-8859-9", new Character('\u00ff'));
            s_revsize.put("ISO-2022-JP", new Character('\uffff'));
            s_revsize.put("SHIFT_JIS", new Character('\uffff'));
            s_revsize.put("EUC-JP", new Character('\uffff'));
            s_revsize.put("GB2312", new Character('\uffff'));
            s_revsize.put("BIG5", new Character('\uffff'));
            s_revsize.put("EUC-KR", new Character('\uffff'));
            s_revsize.put("ISO-2022-KR", new Character('\uffff'));
            s_revsize.put("KOI8-R", new Character('\uffff'));
            s_revsize.put("EBCDIC-CP-US", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-CA", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-NL", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-DK", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-NO", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-FI", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-SE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-IT", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-ES", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-GB", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-FR", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-AR1", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-HE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-CH", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-ROECE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-YU", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-IS", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-AR2", new Character('\u00ff'));
            s_enchash = new Hashtable();
            s_enchash.put("WINDOWS-1250", "Cp1250");
            s_enchash.put(DEFAULT_MIME_ENCODING, "UTF8");
            if (bl) {
                s_enchash.put("US-ASCII", "ISO8859_1");
                s_enchash.put("ISO-8859-1", "ISO8859_1");
                s_enchash.put("ISO-8859-2", "ISO8859_2");
                s_enchash.put("ISO-8859-3", "ISO8859_3");
                s_enchash.put("ISO-8859-4", "ISO8859_4");
                s_enchash.put("ISO-8859-5", "ISO8859_5");
                s_enchash.put("ISO-8859-6", "ISO8859_6");
                s_enchash.put("ISO-8859-7", "ISO8859_7");
                s_enchash.put("ISO-8859-8", "ISO8859_8");
                s_enchash.put("ISO-8859-9", "ISO8859_9");
            } else {
                s_enchash.put("US-ASCII", "8859_1");
                s_enchash.put("ISO-8859-1", "8859_1");
                s_enchash.put("ISO-8859-2", "8859_2");
                s_enchash.put("ISO-8859-3", "8859_3");
                s_enchash.put("ISO-8859-4", "8859_4");
                s_enchash.put("ISO-8859-5", "8859_5");
                s_enchash.put("ISO-8859-6", "8859_6");
                s_enchash.put("ISO-8859-7", "8859_7");
                s_enchash.put("ISO-8859-8", "8859_8");
                s_enchash.put("ISO-8859-9", "8859_9");
            }
            s_enchash.put("ISO-2022-JP", "JIS");
            s_enchash.put("SHIFT_JIS", "SJIS");
            s_enchash.put("EUC-JP", "EUCJIS");
            s_enchash.put("GB2312", "GB2312");
            s_enchash.put("BIG5", "Big5");
            s_enchash.put("EUC-KR", "KSC5601");
            s_enchash.put("ISO-2022-KR", "ISO2022KR");
            s_enchash.put("KOI8-R", "KOI8_R");
            s_enchash.put("EBCDIC-CP-US", "Cp037");
            s_enchash.put("EBCDIC-CP-CA", "Cp037");
            s_enchash.put("EBCDIC-CP-NL", "Cp037");
            s_enchash.put("EBCDIC-CP-DK", "Cp277");
            s_enchash.put("EBCDIC-CP-NO", "Cp277");
            s_enchash.put("EBCDIC-CP-FI", "Cp278");
            s_enchash.put("EBCDIC-CP-SE", "Cp278");
            s_enchash.put("EBCDIC-CP-IT", "Cp280");
            s_enchash.put("EBCDIC-CP-ES", "Cp284");
            s_enchash.put("EBCDIC-CP-GB", "Cp285");
            s_enchash.put("EBCDIC-CP-FR", "Cp297");
            s_enchash.put("EBCDIC-CP-AR1", "Cp420");
            s_enchash.put("EBCDIC-CP-HE", "Cp424");
            s_enchash.put("EBCDIC-CP-CH", "Cp500");
            s_enchash.put("EBCDIC-CP-ROECE", "Cp870");
            s_enchash.put("EBCDIC-CP-YU", "Cp870");
            s_enchash.put("EBCDIC-CP-IS", "Cp871");
            s_enchash.put("EBCDIC-CP-AR2", "Cp918");
            s_revhash = new Hashtable();
            s_revhash.put("CP1252", "ISO-8859-1");
            s_revhash.put("Cp1252", "ISO-8859-1");
            s_revhash.put("CP1250", "WINDOWS-1250");
            s_revhash.put("Cp1250", "WINDOWS-1250");
            s_revhash.put("UTF8", DEFAULT_MIME_ENCODING);
            s_revhash.put(DEFAULT_MIME_ENCODING, DEFAULT_MIME_ENCODING);
            if (bl) {
                s_revhash.put("ISO8859_1", "ISO-8859-1");
                s_revhash.put("ISO8859_2", "ISO-8859-2");
                s_revhash.put("ISO8859_3", "ISO-8859-3");
                s_revhash.put("ISO8859_4", "ISO-8859-4");
                s_revhash.put("ISO8859_5", "ISO-8859-5");
                s_revhash.put("ISO8859_6", "ISO-8859-6");
                s_revhash.put("ISO8859_7", "ISO-8859-7");
                s_revhash.put("ISO8859_8", "ISO-8859-8");
                s_revhash.put("ISO8859_9", "ISO-8859-9");
            } else {
                s_revhash.put("8859_1", "ISO-8859-1");
                s_revhash.put("8859_2", "ISO-8859-2");
                s_revhash.put("8859_3", "ISO-8859-3");
                s_revhash.put("8859_4", "ISO-8859-4");
                s_revhash.put("8859_5", "ISO-8859-5");
                s_revhash.put("8859_6", "ISO-8859-6");
                s_revhash.put("8859_7", "ISO-8859-7");
                s_revhash.put("8859_8", "ISO-8859-8");
                s_revhash.put("8859_9", "ISO-8859-9");
            }
            s_revhash.put("JIS", "ISO-2022-JP");
            s_revhash.put("SJIS", "Shift_JIS");
            s_revhash.put("EUCJIS", "EUC-JP");
            s_revhash.put("GB2312", "GB2312");
            s_revhash.put("BIG5", "Big5");
            s_revhash.put("KSC5601", "EUC-KR");
            s_revhash.put("ISO2022KR", "ISO-2022-KR");
            s_revhash.put("KOI8_R", "KOI8-R");
            s_revhash.put("CP037", "EBCDIC-CP-US");
            s_revhash.put("CP037", "EBCDIC-CP-CA");
            s_revhash.put("CP037", "EBCDIC-CP-NL");
            s_revhash.put("CP277", "EBCDIC-CP-DK");
            s_revhash.put("CP277", "EBCDIC-CP-NO");
            s_revhash.put("CP278", "EBCDIC-CP-FI");
            s_revhash.put("CP278", "EBCDIC-CP-SE");
            s_revhash.put("CP280", "EBCDIC-CP-IT");
            s_revhash.put("CP284", "EBCDIC-CP-ES");
            s_revhash.put("CP285", "EBCDIC-CP-GB");
            s_revhash.put("CP297", "EBCDIC-CP-FR");
            s_revhash.put("CP420", "EBCDIC-CP-AR1");
            s_revhash.put("CP424", "EBCDIC-CP-HE");
            s_revhash.put("CP500", "EBCDIC-CP-CH");
            s_revhash.put("CP870", "EBCDIC-CP-ROECE");
            s_revhash.put("CP870", "EBCDIC-CP-YU");
            s_revhash.put("CP871", "EBCDIC-CP-IS");
            s_revhash.put("CP918", "EBCDIC-CP-AR2");
            s_revhash.put("Cp037", "EBCDIC-CP-US");
            s_revhash.put("Cp037", "EBCDIC-CP-CA");
            s_revhash.put("Cp037", "EBCDIC-CP-NL");
            s_revhash.put("Cp277", "EBCDIC-CP-DK");
            s_revhash.put("Cp277", "EBCDIC-CP-NO");
            s_revhash.put("Cp278", "EBCDIC-CP-FI");
            s_revhash.put("Cp278", "EBCDIC-CP-SE");
            s_revhash.put("Cp280", "EBCDIC-CP-IT");
            s_revhash.put("Cp284", "EBCDIC-CP-ES");
            s_revhash.put("Cp285", "EBCDIC-CP-GB");
            s_revhash.put("Cp297", "EBCDIC-CP-FR");
            s_revhash.put("Cp420", "EBCDIC-CP-AR1");
            s_revhash.put("Cp424", "EBCDIC-CP-HE");
            s_revhash.put("Cp500", "EBCDIC-CP-CH");
            s_revhash.put("Cp870", "EBCDIC-CP-ROECE");
            s_revhash.put("Cp870", "EBCDIC-CP-YU");
            s_revhash.put("Cp871", "EBCDIC-CP-IS");
            s_revhash.put("Cp918", "EBCDIC-CP-AR2");
        }
    }

    static boolean isSupportedJavaEncoding(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(32);
            String string2 = byteArrayOutputStream.toString(string);
            if (string2 != null) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return false;
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    void outputDocTypeDecl(String string) throws SAXException {
        this.accum("<!DOCTYPE ");
        this.accum(string);
        if (this.m_doctypePublic != null) {
            this.accum(" PUBLIC \"");
            this.accum(this.m_doctypePublic);
            this.accum("\"");
        }
        if (this.m_doctypePublic == null) {
            this.accum(" SYSTEM \"");
        } else {
            this.accum(" \"");
        }
        this.accum(this.m_doctypeSystem);
        this.accum("\">");
        this.outputLineSep();
    }

    protected final void outputLineSep() throws SAXException {
        int n = 0;
        while (n < this.m_lineSepLen) {
            this.accum(this.m_lineSep.charAt(n));
            ++n;
        }
    }

    public void printSpace(int n) throws SAXException {
        int n2 = 0;
        while (n2 < n) {
            this.accum(' ');
            ++n2;
        }
    }

    protected void processAttribute(String string, String string2) throws SAXException {
        this.accum(' ');
        this.accum(string);
        this.accum("=\"");
        this.writeAttrString(string2, this.m_encoding);
        this.accum('\"');
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (string.equals("xslt-next-is-raw") && string2.equals("formatter-to-dom")) {
            this.m_nextIsRaw = true;
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('?');
            this.accum(string);
            if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                this.accum(' ');
            }
            this.accum(string2);
            this.accum('?');
            this.accum('>');
            this.m_startNewLine = true;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startDocument() throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String string = this.getMimeEncoding(this.m_encoding);
            String string2 = this.m_version == null ? "1.0" : this.m_version;
            String string3 = this.m_standalone ? " standalone=\"yes\"" : "";
            this.accum("<?xml version=\"" + string2 + "\" encoding=\"" + string + "\"" + string3 + "?>");
            this.outputLineSep();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToOutputDocTypeDecl && this.m_doctypeSystem != null) {
            this.outputDocTypeDecl(string);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.m_ispreserve = false;
        if (this.shouldIndent() && this.m_startNewLine) {
            this.indent(this.m_currentIndent);
        }
        this.m_startNewLine = true;
        this.accum('<');
        this.accum(string);
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.processAttribute(attributeList.getName(n2), attributeList.getValue(n2));
            ++n2;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.indent;
        this.m_isprevtext = false;
    }

    public void startEntity(String string) throws SAXException {
        this.entityReference(string);
        this.m_inEntityRef = true;
    }

    public void writeAttrString(String string, String string2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '\u0100' && this.m_attrCharsMap[c] != 'S') {
                this.accum(c);
            } else {
                this.accumDefaultEscape(c, n2, cArray, n, true);
            }
            ++n2;
        }
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (c == '\r' && n4 + 1 < n3 && cArray[n4 + 1] == '\n') {
                this.outputLineSep();
                ++n4;
            } else if (c == '\n' && n4 + 1 < n3 && cArray[n4 + 1] == '\r') {
                this.outputLineSep();
                ++n4;
            } else if (c == '\n') {
                this.outputLineSep();
            } else if (bl && c > this.m_maxCharacter) {
                if (n4 != 0) {
                    this.accum("]]>");
                }
                if (c >= '\ud800' && c < '\udc00') {
                    int n5;
                    if (n4 + 1 >= n3) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
                    }
                    if ((n5 = cArray[++n4]) < 56320 || n5 >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n5)}));
                    }
                    n5 = (c - 55296 << 10) + n5 - 56320 + 65536;
                    this.accum('&');
                    this.accum('#');
                    this.accum(Integer.toString(n5));
                    this.accum(';');
                } else {
                    this.accum("&#");
                    String string = Integer.toString(c);
                    this.accum(string);
                    this.accum(';');
                }
                if (n4 != 0 && n4 < n3 - 1) {
                    this.accum("<![CDATA[");
                }
            } else if (bl && n4 < n3 - 2 && c == ']' && cArray[n4 + 1] == ']' && cArray[n4 + 2] == '>') {
                this.accum("]]]]><![CDATA[>");
                n4 += 2;
            } else if (c <= this.m_maxCharacter) {
                this.accum(c);
            } else if (c >= '\ud800' && c < '\udc00') {
                int n6;
                if (n4 + 1 >= n3) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
                }
                if ((n6 = cArray[++n4]) < 56320 || n6 >= 57344) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n6)}));
                }
                n6 = (c - 55296 << 10) + n6 - 56320 + 65536;
                this.accum("&#");
                this.accum(Integer.toString(n6));
                this.accum(";");
            } else {
                this.accum("&#");
                String string = Integer.toString(c);
                this.accum(string);
                this.accum(';');
            }
            ++n4;
        }
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.isEmpty() && !this.m_elemStack.peek()) {
            this.accum('>');
            this.m_isprevtext = false;
            this.m_elemStack.pop();
            this.m_elemStack.push(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }
}

