/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.Verifiable;
import com.mockobjects.dynamic.ExpectedCall;
import com.mockobjects.dynamic.ExpectedReturn;
import com.mockobjects.dynamic.ExpectedThrow;
import com.mockobjects.dynamic.P;
import com.mockobjects.dynamic.Predicate;
import com.mockobjects.dynamic.Trainer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class Mock
extends Assert
implements InvocationHandler,
Verifiable {
    public static final Object VOID = new Object();
    public static final Predicate[] NO_ARGS = new Predicate[0];
    private String _name;
    private Map _expectations = new HashMap();
    private Set _not_called_expectations = new HashSet();
    private Map _order_constraints = new HashMap();
    private Set _called_methods = new HashSet();
    private boolean _strict = false;
    private Map _default_results = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public Mock(String name) {
        this._name = name;
        this.setupDefaultResult(Byte.TYPE, new Byte(0));
        this.setupDefaultResult(Short.TYPE, new Short(0));
        this.setupDefaultResult(Integer.TYPE, new Integer(0));
        this.setupDefaultResult(Long.TYPE, new Long(0L));
        this.setupDefaultResult(Float.TYPE, new Float(0.0f));
        this.setupDefaultResult(Double.TYPE, new Double(0.0));
        this.setupDefaultResult(Boolean.TYPE, Boolean.FALSE);
        this.setupDefaultResult(Character.TYPE, new Character('\u0000'));
        this.setupDefaultResult(class$java$lang$String == null ? (class$java$lang$String = Mock.class$("java.lang.String")) : class$java$lang$String, "");
    }

    public Mock() {
        this(null);
        this._name = super.toString();
    }

    public String toString() {
        return this._name;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setup(ExpectedCall call) {
        String methodName = call.getMethodName();
        this._expectations.put(methodName, call);
        this._not_called_expectations.remove(methodName);
        this._called_methods.add(methodName);
    }

    public void setupResult(String method_name, Object result) {
        this.setup(new ExpectedReturn(method_name, null, result));
    }

    public void setupThrow(String method_name, Throwable exception) {
        this.setup(new ExpectedThrow(method_name, null, exception));
    }

    public void setupDefaultResult(Class result_type, Object result_value) {
        this._default_results.put(result_type, result_value);
    }

    public void expect(ExpectedCall call) {
        String methodName = call.getMethodName();
        this._expectations.put(methodName, call);
        this._not_called_expectations.remove(methodName);
        this._called_methods.remove(methodName);
    }

    public void expectReturn(String method, Predicate[] args, Object result) {
        this.expect(new ExpectedReturn(method, args, result));
    }

    public void expectReturn(String method, Object arg, Object result) {
        this.expectReturn(method, P.args(P.eq(arg)), result);
    }

    public void expectReturn(String method, Object result) {
        this.expectReturn(method, NO_ARGS, result);
    }

    public void expectVoid(String method, Predicate[] args) {
        this.expect(new ExpectedReturn(method, args, VOID));
    }

    public void expectVoid(String method, Object arg) {
        this.expectVoid(method, P.args(P.eq(arg)));
    }

    public void expectVoid(String method) {
        this.expectVoid(method, NO_ARGS);
    }

    public void expectThrow(String method, Predicate[] args, Throwable exception) {
        this.expect(new ExpectedThrow(method, args, exception));
    }

    public void expectThrow(String method, Object arg, Throwable exception) {
        this.expectThrow(method, P.args(P.eq(arg)), exception);
    }

    public void expectThrow(String method, Throwable exception) {
        this.expectThrow(method, NO_ARGS, exception);
    }

    public void expectNotCalled(String method) {
        this._not_called_expectations.add(method);
    }

    public void order(String preceding_method, String subsequent_method) {
        HashSet<String> preceding_calls = this.orderConstraintsFor(subsequent_method);
        if (null == preceding_calls) {
            preceding_calls = new HashSet<String>();
            this._order_constraints.put(subsequent_method, preceding_calls);
        }
        preceding_calls.add(preceding_method);
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        this._called_methods.add(method.getName());
        try {
            return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
        }
        catch (NoSuchMethodException ex) {
            return this.mockCall(method, args);
        }
    }

    protected Object mockCall(Method method, Object[] args) throws Throwable {
        String method_name = method.getName();
        this.assertCanBeCalled(method_name);
        if (this._expectations.containsKey(method_name)) {
            ExpectedCall expected = (ExpectedCall)((Object)this._expectations.get(method_name));
            this.checkCallOrder(method_name);
            if (expected.isTestingArguments()) {
                this.checkArguments(expected, args);
            }
            return this.checkResult(method, expected.eval(args));
        }
        if (this._strict) {
            throw new AssertionFailedError(this._name + ": unexpected call to " + method_name);
        }
        return this.defaultResult(method.getReturnType());
    }

    private Object checkResult(Method method, Object result) {
        if (method.getReturnType() == Void.TYPE && VOID != result) {
            Assert.fail((String)("trying to return " + result + " from void method"));
        }
        return result;
    }

    private void checkCallOrder(String method_name) {
        if (this._order_constraints.containsKey(method_name)) {
            this.assertMethodsHaveBeenCalled(this.orderConstraintsFor(method_name));
        }
    }

    private Set orderConstraintsFor(String method_name) {
        return (Set)this._order_constraints.get(method_name);
    }

    private void checkArguments(ExpectedCall expected, Object[] args) {
        int arg_count = args == null ? 0 : args.length;
        Assert.assertEquals((String)(this._name + ": wrong number of arguments to " + expected.getMethodName() + " method"), (int)expected.getArgumentCount(), (int)arg_count);
        int i = 0;
        while (i < arg_count) {
            Object arg = args[i];
            if (!expected.testArgument(i, arg)) {
                Assert.fail((String)(this._name + ": unexpected argument " + (i + 1) + " to " + expected.getMethodName() + " method" + ", expected " + expected.describeArgument(i) + ", was " + arg));
            }
            ++i;
        }
    }

    private Object defaultResult(Class return_type) {
        return this._default_results.get(return_type);
    }

    public void verify() {
        this.assertAllExpectedMethodsCalled();
    }

    private void assertAllExpectedMethodsCalled() {
        this.assertMethodsHaveBeenCalled(this._expectations.keySet());
    }

    private void assertMethodsHaveBeenCalled(Set method_names) {
        Iterator i = method_names.iterator();
        while (i.hasNext()) {
            this.assertHasBeenCalled((String)i.next());
        }
    }

    private void assertHasBeenCalled(String method_name) {
        if (!this._called_methods.contains(method_name)) {
            Assert.fail((String)(this._name + ": method " + method_name + " was not called"));
        }
    }

    private void assertCanBeCalled(String method_name) {
        if (this._not_called_expectations.contains(method_name)) {
            Assert.fail((String)(this._name + ": unexpected call to method " + method_name));
        }
    }

    public Object createInterface(Class interface_class) {
        return this.createInterface(interface_class, this);
    }

    public Object getTrainer(Class interfaceClass) {
        return this.createInterface(interfaceClass, new Trainer(this));
    }

    private Object createInterface(Class interface_class, InvocationHandler handler) {
        return Proxy.newProxyInstance(interface_class.getClassLoader(), new Class[]{interface_class}, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

