/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.Iterator;

public class Counter
implements Iterator {
    long first;
    long current;
    long interval;
    long last;
    boolean wrap;

    public Counter() {
        this.current = this.first = 1L;
        this.interval = 1L;
        this.last = -1L;
        this.wrap = false;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getFirst() {
        return this.first;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getLast() {
        return this.last;
    }

    public long getNext() {
        long next = this.current;
        this.current += this.interval;
        if (this.wrap && this.current > this.last) {
            this.current -= 1L + this.last - this.first;
        }
        return next;
    }

    public long getPrevious() {
        this.current -= this.interval;
        if (this.wrap && this.current < this.first) {
            this.current += this.last - this.first + 1L;
        }
        return this.current;
    }

    public boolean hasNext() {
        return this.last == -1L || this.wrap ? true : this.current <= this.last;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public Object next() {
        return new Long(this.getNext());
    }

    public void remove() {
    }

    public void setAdd(long addition) {
        this.current += addition;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setFirst(long first) {
        this.first = first;
        this.current = first;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }
}

