/*
 * Decompiled with CFR 0.152.
 */
package webwork.multipart;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import webwork.config.Configuration;
import webwork.multipart.CosMultiPartRequest;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.PellMultiPartRequest;

public class MultiPartRequestWrapper
extends HttpServletRequestWrapper {
    MultiPartRequest multi;

    public MultiPartRequestWrapper(HttpServletRequest request, String saveDir, Integer maxSize) throws IOException {
        super(request);
        if (request instanceof MultiPartRequest) {
            this.multi = (MultiPartRequest)request;
        } else {
            String parser = Configuration.getString("webwork.multipart.parser");
            if ("cos".equals(parser)) {
                this.multi = new CosMultiPartRequest(request, saveDir, maxSize);
            } else if ("pell".equals(parser)) {
                this.multi = new PellMultiPartRequest(request, saveDir, maxSize);
            } else {
                throw new IOException("Not multipart parse specified in webwork.properties.");
            }
        }
    }

    public String getContentType(String name) {
        return this.multi.getContentType(name);
    }

    public File getFile(String name) {
        return this.multi.getFile(name);
    }

    public Enumeration getFileNames() {
        return this.multi.getFileNames();
    }

    public String getFilesystemName(String name) {
        return this.multi.getFilesystemName(name);
    }

    public String getParameter(String name) {
        return this.multi.getParameter(name) == null ? super.getParameter(name) : this.multi.getParameter(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration getParameterNames() {
        return this.mergeParams(this.multi.getParameterNames(), super.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        return this.multi.getParameterValues(name) == null ? super.getParameterValues(name) : this.multi.getParameterValues(name);
    }

    protected Enumeration mergeParams(Enumeration params1, Enumeration params2) {
        Vector temp = new Vector();
        while (params1.hasMoreElements()) {
            temp.add(params1.nextElement());
        }
        while (params2.hasMoreElements()) {
            temp.add(params2.nextElement());
        }
        return temp.elements();
    }
}

