/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.standard;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionSupport;
import webwork.action.ParameterAware;

public class Script
extends ActionSupport
implements ParameterAware {
    boolean exists = true;
    String scriptName;
    URL scriptUrl;
    Map parameters;
    BSFManager mgr = new BSFManager();
    BSFEngine engine;
    Map resultMap = new ScriptMap();
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String execute() throws Exception {
        try {
            URL scriptUrl = this.getScriptURL();
            String script = this.getScriptContent(scriptUrl);
            this.registerVariables();
            this.engine = this.getScriptingEngine();
            this.engine.exec(scriptUrl.getFile(), -1, -1, (Object)script);
            return this.engine.eval(null, -1, -1, (Object)"result").toString();
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public Map getResults() {
        return this.resultMap;
    }

    protected String getScriptContent(URL scriptUrl) throws IOException {
        InputStreamReader in = new InputStreamReader(scriptUrl.openStream());
        String script = IOUtils.getStringFromReader((Reader)in);
        return script;
    }

    public URL getScriptURL() {
        if (this.scriptUrl == null) {
            String ext = this.scriptName.substring(this.scriptName.lastIndexOf("."));
            String realScriptName = this.scriptName.substring(0, this.scriptName.length() - ext.length());
            realScriptName = realScriptName.replace('.', '/');
            realScriptName = String.valueOf(realScriptName) + ext;
            this.scriptUrl = this.getClass().getClassLoader().getResource(realScriptName);
        }
        return this.scriptUrl;
    }

    protected BSFEngine getScriptingEngine() throws BSFException {
        String language = BSFManager.getLangFromFilename((String)this.scriptName);
        return this.mgr.loadScriptingEngine(language);
    }

    protected String handleException(Exception e) {
        e.printStackTrace();
        return "error";
    }

    protected void registerVariables() throws BSFException {
        Iterator params = this.parameters.entrySet().iterator();
        while (params.hasNext()) {
            Map.Entry entry = params.next();
            String key = (String)entry.getKey();
            String value = ((String[])entry.getValue())[0];
            this.mgr.declareBean(key, (Object)value, class$java$lang$String != null ? class$java$lang$String : Script.class$("java.lang.String"));
        }
        this.mgr.declareBean("action", (Object)this, this.getClass());
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void setScript(String scriptName) {
        this.scriptName = scriptName;
    }

    class ScriptMap
    extends AbstractMap {
        ScriptMap() {
        }

        public void clear() {
            throw new UnsupportedOperationException("Can't remove scripting variables");
        }

        public boolean containsKey(Object key) {
            try {
                Script.this.engine.eval(null, -1, -1, key);
                return true;
            }
            catch (BSFException bSFException) {
                return false;
            }
        }

        public Set entrySet() {
            new Throwable().printStackTrace();
            throw new UnsupportedOperationException("Can't get scripting variable set");
        }

        public Object get(Object key) {
            try {
                return Script.this.engine.eval(null, -1, -1, key);
            }
            catch (BSFException bSFException) {
                throw new IllegalArgumentException("Could not evaluate variable name " + key);
            }
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("Can't set scripting variable");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("Can't remove scripting variable");
        }
    }
}

