/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class ApplicationMap
extends AbstractMap {
    ServletContext context;
    Set entries;

    public ApplicationMap(ServletContext ctx) {
        this.context = ctx;
    }

    public void clear() {
        this.entries = null;
        Enumeration enumeration = this.context.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.context.removeAttribute(enumeration.nextElement().toString());
        }
    }

    public Set entrySet() {
        if (this.entries == null) {
            Object value;
            String key;
            this.entries = new HashSet();
            Enumeration enumeration = this.context.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement().toString();
                value = this.context.getAttribute(key);
                this.entries.add(new Map.Entry(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        if (key == null) {
                            if (entry.getKey() != null) {
                                return false;
                            }
                        } else {
                            boolean bl = key.equals(entry.getKey());
                            if (!bl) return false;
                        }
                        if (value == null) {
                            if (entry.getValue() == null) return true;
                            return false;
                        }
                        boolean bl = value.equals(entry.getValue());
                        if (bl) return true;
                        return false;
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object setValue(Object obj) {
                        context.setAttribute(key.toString(), obj);
                        return value;
                    }
                });
            }
            enumeration = this.context.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement().toString();
                value = this.context.getInitParameter(key);
                this.entries.add(new Map.Entry(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        if (key == null) {
                            if (entry.getKey() != null) {
                                return false;
                            }
                        } else {
                            boolean bl = key.equals(entry.getKey());
                            if (!bl) return false;
                        }
                        if (value == null) {
                            if (entry.getValue() == null) return true;
                            return false;
                        }
                        boolean bl = value.equals(entry.getValue());
                        if (bl) return true;
                        return false;
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object setValue(Object obj) {
                        context.setAttribute(key.toString(), obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    public Object get(Object key) {
        Object value = this.context.getAttribute(key.toString());
        return value == null ? this.context.getInitParameter((String)key) : value;
    }

    public Object put(Object key, Object value) {
        this.entries = null;
        this.context.setAttribute(key.toString(), value);
        return this.get(key);
    }

    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.context.removeAttribute(key.toString());
        return value;
    }
}

