/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import webwork.util.AbstractValueStack;

public class ValueStack
extends AbstractValueStack {
    private ServletRequest request;
    private PageContext context;

    protected Object findInContext(String id) {
        if (this.context != null) {
            try {
                return this.context.findAttribute(id);
            }
            catch (Exception exception) {
                return this.request.getAttribute(id);
            }
        }
        return this.request.getAttribute(id);
    }

    protected String getRequestParameter(String id) {
        return this.request.getParameter(id);
    }

    public static ValueStack getStack(ServletRequest request) {
        ValueStack stack = (ValueStack)request.getAttribute("webwork.result");
        if (stack == null) {
            stack = new ValueStack();
            request.setAttribute("webwork.result", (Object)stack);
        }
        stack.setRequest(request);
        return stack;
    }

    public static ValueStack getStack(PageContext context) {
        ServletRequest request = context.getRequest();
        ValueStack stack = (ValueStack)request.getAttribute("webwork.result");
        if (stack == null) {
            stack = new ValueStack();
            request.setAttribute("webwork.result", (Object)stack);
        }
        stack.setRequest(request);
        stack.setContext(context);
        return stack;
    }

    private void setContext(PageContext context) {
        this.context = context;
    }

    private void setRequest(ServletRequest request) {
        this.request = request;
    }
}

