/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javastyle;

import java.io.File;
import java.util.Vector;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class JavaStyle
extends MatchingTask {
    protected File file = null;
    protected Vector filesets = new Vector();
    private int verbosity = 3;
    private boolean quiet = false;

    public void setFile(File file) {
        this.file = file;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " is not a file, use the dir attribute instead.");
                } else {
                    this.log("JavaStyling: " + this.file.getAbsolutePath());
                    this.styleFile(this.file);
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to style.");
            }
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(((ProjectComponent)this).project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.styleFiles(fileSet.getDir(((ProjectComponent)this).project), stringArray);
            ++n;
        }
    }

    public void init() throws BuildException {
        new RefactoryInstaller(false).run();
    }

    protected void styleFile(File file) {
        PrettyPrintFile prettyPrintFile = new PrettyPrintFile();
        prettyPrintFile.setAsk(false);
        if (prettyPrintFile.isApplicable(file)) {
            prettyPrintFile.apply(file);
        }
    }

    protected void styleFiles(File file, String[] stringArray) {
        if (stringArray.length > 0) {
            this.log("JavaStyling " + stringArray.length + " files from " + file.getAbsolutePath());
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                this.log("JavaStyling " + file2.getAbsolutePath(), this.verbosity);
                this.styleFile(file2);
                ++n;
            }
        }
    }
}

