/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.version.VersionControl;

public class SourceSafe
implements VersionControl {
    private String exeFile;
    private String user;

    public SourceSafe() {
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "vss");
            this.exeFile = fileSettings.getString("vss");
        }
        catch (MissingSettingsException missingSettingsException) {
            System.out.println("Unable to initialize source safe");
            ExceptionPrinter.print(missingSettingsException, false);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Unable to interpret the count property as an integer");
        }
    }

    public synchronized boolean contains(String string) {
        try {
            System.out.println("\tChecking for " + string);
            String string2 = this.getProject(Runtime.getRuntime(), string);
            boolean bl = string2 != null && string2.length() > 0;
            System.out.println("\t" + string + " is " + (bl ? "" : "not ") + "in Source Safe");
            return bl;
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
            return false;
        }
    }

    public synchronized void add(String string) {
    }

    public synchronized void checkOut(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            System.out.println("\tFinding the project");
            String string2 = this.getProject(runtime, string);
            if (string2 == null) {
                System.out.println("\tNot in any project");
                return;
            }
            System.out.println("\tChanging to project:  " + string2);
            this.changeProject(runtime, string2);
            System.out.println("\tChecking out the file:  " + string);
            this.checkout(runtime, string);
            System.out.println("\tDone:  " + string);
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    public synchronized void checkIn(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            System.out.println("\tFinding the project");
            String string2 = this.getProject(runtime, string);
            if (string2 == null) {
                System.out.println("\tNot in any project");
                return;
            }
            System.out.println("\tChecking in the file to " + string2);
            this.changeProject(runtime, string2);
            System.out.println("\tChanged to the project");
            this.checkin(runtime, string);
            System.out.println("\tDone:  " + string);
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    protected String getProject(Runtime runtime, String string) throws IOException {
        System.out.println("DEBUG[SourceSafe.getProject]  #1");
        BufferedReader bufferedReader = this.executeLocate(runtime, string);
        System.out.println("DEBUG[SourceSafe.getProject]  #2");
        String string2 = bufferedReader.readLine();
        System.out.println("DEBUG[SourceSafe.getProject]  #3 - " + string2);
        String string3 = this.getPath(string);
        System.out.println("DEBUG[SourceSafe.getProject]  #4 - " + string3);
        String string4 = bufferedReader.readLine();
        if (this.isNotInSourceSafe(string4)) {
            return null;
        }
        System.out.println("DEBUG[SourceSafe.getProject]  #5 - " + string4);
        int n = -1;
        do {
            System.out.println("DEBUG[SourceSafe.getProject]  #6");
            if (string4.indexOf("(Deleted)") == -1) {
                System.out.println("DEBUG[SourceSafe.getProject]  #7");
                String string5 = this.extractProjectName(string4);
                System.out.println("DEBUG[SourceSafe.getProject]  #8 - " + string5);
                if (this.match(string3, string5) != -1) {
                    System.out.println("DEBUG[SourceSafe.getProject]  #9");
                    return string5;
                }
            }
            System.out.println("DEBUG[SourceSafe.getProject]  #10");
            string4 = bufferedReader.readLine();
            System.out.println("DEBUG[SourceSafe.getProject]  #11 - " + string4);
            if (string4.length() == 0 || string4.charAt(0) != '$') {
                return null;
            }
            System.out.println("DEBUG[SourceSafe.getProject]  #12");
        } while (n == -1);
        System.out.println("DEBUG[SourceSafe.getProject]  #13");
        return null;
    }

    protected String getFilename(String string) {
        File file = new File(string);
        return file.getName();
    }

    protected String getPath(String string) {
        File file = new File(string);
        return file.getParentFile().getPath();
    }

    protected void changeProject(Runtime runtime, String string) throws IOException {
        String[] stringArray = new String[]{this.exeFile, "CP", string};
        Process process = runtime.exec(stringArray);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void checkout(Runtime runtime, String string) throws IOException {
        String[] stringArray = new String[]{this.exeFile, "CHECKOUT", this.getFilename(string)};
        Process process = runtime.exec(stringArray);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void checkin(Runtime runtime, String string) throws IOException {
        String[] stringArray = new String[]{this.exeFile, "CHECKIN", this.getFilename(string)};
        Process process = runtime.exec(stringArray);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int match(String string, String string2) {
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "vss");
            int n = 1;
            while (true) {
                String string3 = fileSettings.getString("source." + n);
                String string4 = fileSettings.getString("project." + n);
                if (this.startSame(string, string3) && this.startSame(string2, string4)) {
                    String string5 = string.substring(string3.length());
                    String string6 = string2.substring(string4.length());
                    System.out.println("    Rest [" + string5 + "] [" + string6 + "]");
                    if (this.compare(string5, string6)) {
                        System.out.println("\t\tFound!");
                        return n;
                    }
                }
                System.out.println("Not this pair...  " + n);
                ++n;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            return -1;
        }
    }

    protected boolean compare(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            char c2 = string2.charAt(n2);
            if (c == '/' ? c2 != '/' && c2 != '\\' : (c == '\\' ? c2 != '/' && c2 != '\\' : c != c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isNotInSourceSafe(String string) {
        if (string == null) {
            return true;
        }
        String string2 = string.trim();
        if (string2 == null) {
            return true;
        }
        return string2.equals("No matches found.");
    }

    private BufferedReader executeLocate(Runtime runtime, String string) throws IOException {
        String[] stringArray = new String[]{this.exeFile, "LOCATE", this.getFilename(string)};
        Process process = runtime.exec(stringArray);
        InputStream inputStream = process.getInputStream();
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private String extractProjectName(String string) {
        int n = string.lastIndexOf("/");
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    private boolean startSame(String string, String string2) {
        System.out.println("    Comparing   prefix:[" + string2 + "]   full:[" + string + "]");
        return string.startsWith(string2);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Syntax:  java org.acm.seguin.version.SourceSafe filename");
            return;
        }
        new SourceSafe().checkIn(stringArray[0]);
    }
}

