/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.acm.seguin.uml.line.TextInfo;

public class LabelSizeComputation {
    private Graphics g;
    private static LabelSizeComputation singleton;

    private LabelSizeComputation() {
        BufferedImage bufferedImage = new BufferedImage(300, 25, 1);
        this.g = bufferedImage.getGraphics();
    }

    public TextInfo compute(String string, Font font) {
        TextInfo textInfo = new TextInfo();
        this.g.setFont(font);
        FontMetrics fontMetrics = this.g.getFontMetrics();
        textInfo.height = Math.max(1, fontMetrics.getHeight());
        textInfo.width = string != null ? Math.max(1, fontMetrics.stringWidth(string)) : 1;
        textInfo.ascent = fontMetrics.getAscent();
        return textInfo;
    }

    public int computeHeight(String string, Font font) {
        TextInfo textInfo = this.compute(string, font);
        return textInfo.height;
    }

    public static LabelSizeComputation get() {
        if (singleton == null) {
            LabelSizeComputation.init();
        }
        return singleton;
    }

    private static synchronized void init() {
        if (singleton == null) {
            singleton = new LabelSizeComputation();
        }
    }
}

