/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.uml.UMLMouseAdapter;
import org.acm.seguin.uml.line.DragPanelAdapter;
import org.acm.seguin.uml.line.SizableLabel;

public class RoleHolder
extends JPanel {
    private LinkedList labels;
    private int wide;
    private int high;
    private UMLMouseAdapter popupMenuListener;
    private DragPanelAdapter panelDragAdapter;

    public RoleHolder(UMLMouseAdapter uMLMouseAdapter, DragPanelAdapter dragPanelAdapter) {
        this.setLayout(null);
        this.labels = new LinkedList();
        this.wide = 0;
        this.high = 0;
        this.popupMenuListener = uMLMouseAdapter;
        this.panelDragAdapter = dragPanelAdapter;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void add(String string) {
        SizableLabel sizableLabel = new SizableLabel(string);
        sizableLabel.setSLFont(UMLLine.defaultFont);
        sizableLabel.setSLHorizontalAlignment(0);
        sizableLabel.setLocation(0, this.high);
        this.add(sizableLabel);
        Dimension dimension = sizableLabel.getPreferredSize();
        sizableLabel.setSize(dimension);
        this.wide = Math.max(this.wide, dimension.width);
        this.high += dimension.height;
        sizableLabel.addMouseListener(this.popupMenuListener);
        sizableLabel.addMouseListener(this.panelDragAdapter);
        sizableLabel.addMouseMotionListener(this.panelDragAdapter);
        this.labels.add(sizableLabel);
    }

    public boolean hasAny() {
        return this.high > 0;
    }

    public void resetWidth(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.width = n;
        this.setSize(dimension);
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            SizableLabel sizableLabel = (SizableLabel)iterator.next();
            dimension = sizableLabel.getPreferredSize();
            dimension.width = n;
            sizableLabel.setSize(dimension);
        }
    }

    public void print(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        graphics.setFont(UMLLine.defaultFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            SizableLabel sizableLabel = (SizableLabel)iterator.next();
            Point point = sizableLabel.getLocation();
            sizableLabel.print(graphics, n + point.x, n2 + point.y);
        }
    }

    public void scale(double d) {
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            SizableLabel sizableLabel = (SizableLabel)iterator.next();
            sizableLabel.scale(d);
        }
    }
}

