/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.acm.seguin.uml.UMLIcon;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class ProtectionIcon
extends UMLIcon {
    private int protection;
    private int type;
    private static final int CIRCLE = 0;
    private static final int LETTER = 1;

    public ProtectionIcon(int n, int n2) {
        super(n, n2);
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "uml");
            fileSettings.setContinuallyReload(false);
            String string = fileSettings.getString("icon.type");
            this.type = string.equalsIgnoreCase("letter") ? 1 : 0;
        }
        catch (MissingSettingsException missingSettingsException) {
            this.type = 0;
        }
    }

    public void setProtection(int n) {
        this.protection = n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.type == 1) {
            this.drawLetterIcon(graphics, n, n2);
        } else {
            this.drawCircleIcon(graphics, n, n2);
        }
    }

    private void drawCircleIcon(Graphics graphics, int n, int n2) {
        graphics.setColor(UMLLine.getProtectionColor(this.protection));
        int n3 = Math.max(1, (int)((double)this.iconWidth * this.scale));
        int n4 = Math.max(1, (int)((double)this.iconHeight * this.scale));
        int n5 = (int)this.scale;
        graphics.fillOval(n + n5, n2, n3, n4);
        if (n3 > 1 && n4 > 1) {
            graphics.setColor(Color.black);
            graphics.drawOval(n + n5, n2, n3, n4);
        }
    }

    private void drawLetterIcon(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        int n3 = Math.max(1, (int)((double)this.iconWidth * this.scale));
        int n4 = Math.max(1, (int)((double)this.iconHeight * this.scale));
        int n5 = (int)this.scale;
        int n6 = n4 / 2;
        int n7 = n3 / 2;
        if (this.protection == 0) {
            graphics.drawLine(n + n5, n2 + n6, n + n5 + n3, n2 + n6);
            graphics.drawLine(n + n5 + n7, n2, n + n5 + n7, n2 + n4);
        } else if (this.protection == 2) {
            graphics.drawLine(n + n5, n2 + n6 + 1, n + n5 + n3, n2 + n6 + 1);
            graphics.drawLine(n + n5, n2 + n6 - 1, n + n5 + n3, n2 + n6 - 1);
            graphics.drawLine(n + n5 + n7 + 1, n2, n + n5 + n7 + 1, n2 + n4);
            graphics.drawLine(n + n5 + n7 - 1, n2, n + n5 + n7 - 1, n2 + n4);
        } else if (this.protection == 3) {
            graphics.drawLine(n + n5, n2 + n6 + 1, n + n5 + n3, n2 + n6 + 1);
            graphics.drawLine(n + n5, n2 + n6 - 1, n + n5 + n3, n2 + n6 - 1);
        } else if (this.protection == 4) {
            graphics.drawLine(n + n5, n2 + n6, n + n5 + n3, n2 + n6);
        }
    }
}

