/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.stub;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.InputStreamParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.tools.stub.StubPrintVisitor;

public class StubFile {
    private ParserFactory factory = null;
    private OutputStream out = null;
    private String name;
    private File outputFile;
    private static boolean creating = false;
    static /* synthetic */ Class class$org$acm$seguin$tools$stub$StubFile;

    public StubFile(String string, File file) {
        this.name = string;
        this.outputFile = file;
        creating = true;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.factory = parserFactory;
    }

    public ParserFactory getParserFactory() {
        return this.factory;
    }

    public void apply(File file) {
        this.setParserFactory(new FileParserFactory(file));
        this.apply();
    }

    public void apply(InputStream inputStream, String string) {
        this.setParserFactory(new InputStreamParserFactory(inputStream, string));
        this.apply();
    }

    public void done() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        creating = false;
        StubFile.resume();
    }

    protected OutputStream getOutputStream(File file) {
        if (this.out != null) {
            return this.out;
        }
        if (this.name != null) {
            String string = System.getProperty("user.home");
            File file2 = new File(string + File.separator + ".Refactory");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                File file3 = new File(file2, this.name + ".stub");
                this.out = new FileOutputStream(file3.getPath(), true);
            }
            catch (IOException iOException) {
                this.out = System.out;
            }
        } else {
            try {
                this.out = new FileOutputStream(this.outputFile.getPath(), true);
            }
            catch (IOException iOException) {
                this.out = System.out;
            }
        }
        return this.out;
    }

    private PrintData getPrintData(File file) {
        return new PrintData(this.getOutputStream(file));
    }

    private void apply() {
        StubPrintVisitor stubPrintVisitor = new StubPrintVisitor();
        PrintData printData = this.getPrintData(null);
        SimpleNode simpleNode = this.factory.getAbstractSyntaxTree(false);
        if (simpleNode != null) {
            stubPrintVisitor.visit(simpleNode, (Object)printData);
        }
        printData.flush();
        try {
            this.out.write("\n\n|\n".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    public static synchronized void waitForCreation() {
        if (creating) {
            try {
                (class$org$acm$seguin$tools$stub$StubFile == null ? (class$org$acm$seguin$tools$stub$StubFile = StubFile.class$("org.acm.seguin.tools.stub.StubFile")) : class$org$acm$seguin$tools$stub$StubFile).wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static synchronized void resume() {
        (class$org$acm$seguin$tools$stub$StubFile == null ? (class$org$acm$seguin$tools$stub$StubFile = StubFile.class$("org.acm.seguin.tools.stub.StubFile")) : class$org$acm$seguin$tools$stub$StubFile).notifyAll();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

