/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.acm.seguin.tools.install.TagLinePanel;

public class TagEditorPanel
extends JPanel {
    private JLabel tagNameLabel = new JLabel("Tag Name:");
    private JTextField tagNameTextField = new JTextField(10);
    private JLabel descriptionLabel = new JLabel("Description:");
    private JTextField descriptionTextField = new JTextField(20);
    private JCheckBox classCheckBox = new JCheckBox("Class");
    private JCheckBox methodCheckBox = new JCheckBox("Method");
    private JCheckBox fieldCheckBox = new JCheckBox("Field");
    private JButton updateButton = new JButton("Add");
    private JButton clearButton = new JButton("Delete");

    public TagEditorPanel() {
        this.setLayout(new FlowLayout());
        this.add(this.tagNameLabel);
        this.add(this.tagNameTextField);
        this.add(this.descriptionLabel);
        this.add(this.descriptionTextField);
        this.add(this.classCheckBox);
        this.add(this.methodCheckBox);
        this.add(this.fieldCheckBox);
        this.add(this.updateButton);
        this.add(this.clearButton);
    }

    public void load(TagLinePanel tagLinePanel) {
        if (tagLinePanel == null) {
            this.tagNameTextField.setText("");
            this.descriptionTextField.setText("");
            this.classCheckBox.setSelected(false);
            this.fieldCheckBox.setSelected(false);
            this.methodCheckBox.setSelected(false);
            return;
        }
        this.tagNameTextField.setText(tagLinePanel.getTagName());
        this.descriptionTextField.setText(tagLinePanel.getDescription());
        this.classCheckBox.setSelected(tagLinePanel.isClassType());
        this.fieldCheckBox.setSelected(tagLinePanel.isFieldType());
        this.methodCheckBox.setSelected(tagLinePanel.isMethodType());
    }

    public void save(TagLinePanel tagLinePanel) {
        tagLinePanel.setTagName(this.tagNameTextField.getText());
        tagLinePanel.setDescription(this.descriptionTextField.getText());
        tagLinePanel.setClassType(this.classCheckBox.isSelected());
        tagLinePanel.setMethodType(this.methodCheckBox.isSelected());
        tagLinePanel.setFieldType(this.fieldCheckBox.isSelected());
    }

    public void addUpdateListener(ActionListener actionListener) {
        this.updateButton.addActionListener(actionListener);
    }

    public void removeUpdateListener(ActionListener actionListener) {
        this.updateButton.removeActionListener(actionListener);
    }

    public void addClearListener(ActionListener actionListener) {
        this.clearButton.addActionListener(actionListener);
    }

    public void removeClearListener(ActionListener actionListener) {
        this.clearButton.removeActionListener(actionListener);
    }

    public String getTagName() {
        return this.tagNameTextField.getText();
    }
}

