/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.acm.seguin.awt.OrderableList;
import org.acm.seguin.tools.install.AlphabeticalOrderPanel;
import org.acm.seguin.tools.install.BeanOrderPanel;
import org.acm.seguin.tools.install.FinalOrderPanel;
import org.acm.seguin.tools.install.GetterSetterOrderPanel;
import org.acm.seguin.tools.install.InitializerOrderPanel;
import org.acm.seguin.tools.install.ProtectionOrderPanel;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.tools.install.StaticOrderPanel;
import org.acm.seguin.tools.install.TypeOrderPanel;
import org.acm.seguin.util.Comparator;
import org.acm.seguin.util.InsertionSortArray;

class SortControlSettingPanel
extends SettingPanel {
    private OrderableList list;
    private EtchedBorder etch = new EtchedBorder();
    private BevelBorder bevel = new BevelBorder(0);
    private GridBagConstraints constraints;
    private SortSettingPanel[] data;

    public SortControlSettingPanel() {
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = -1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.ipadx = 0;
        this.constraints.ipady = 0;
        this.addDescription("The following controls the order of methods, fields,");
        this.addDescription("classes, etc inside a class.");
        this.addControl();
    }

    public String getKey() {
        return "sort";
    }

    public void addControl() {
        this.data = new SortSettingPanel[]{new TypeOrderPanel(), new GetterSetterOrderPanel(), new FinalOrderPanel(), new ProtectionOrderPanel(), new StaticOrderPanel(), new BeanOrderPanel(), new AlphabeticalOrderPanel(), new InitializerOrderPanel()};
        InsertionSortArray insertionSortArray = new InsertionSortArray();
        insertionSortArray.sort(this.data, new ComparePanels());
        this.list = new OrderableList(this.data, null);
        ++this.constraints.gridy;
        this.add((Component)this.list, this.constraints);
        int n = 0;
        while (n < this.data.length) {
            ++this.constraints.gridy;
            this.add((Component)this.data[n], this.constraints);
            ++n;
        }
    }

    public void generateSetting(PrintWriter printWriter) {
        this.printDescription(printWriter);
        Object[] objectArray = this.list.getData();
        int n = 1;
        int n2 = 0;
        while (n2 < objectArray.length) {
            SortSettingPanel sortSettingPanel = (SortSettingPanel)objectArray[n2];
            if (sortSettingPanel.isSortEnabled()) {
                sortSettingPanel.generateSetting(printWriter, n);
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            SortSettingPanel sortSettingPanel = (SortSettingPanel)objectArray[n3];
            if (!sortSettingPanel.isSortEnabled()) {
                sortSettingPanel.generateSetting(printWriter, n);
                ++n;
            }
            ++n3;
        }
    }

    protected void addLabel(String string) {
        ++this.constraints.gridy;
        this.add((Component)new JLabel(string), this.constraints);
    }

    protected String getInitialValue() {
        return "";
    }

    public void reload() {
        int n = 0;
        while (n < this.data.length) {
            this.data[n].setOrder(1000);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2].reload();
            ++n2;
        }
        InsertionSortArray insertionSortArray = new InsertionSortArray();
        insertionSortArray.sort(this.data, new ComparePanels());
        this.list.resetModel(this.data);
    }

    private class ComparePanels
    implements Comparator {
        private ComparePanels() {
        }

        public int compare(Object object, Object object2) {
            SortSettingPanel sortSettingPanel = (SortSettingPanel)object;
            SortSettingPanel sortSettingPanel2 = (SortSettingPanel)object2;
            if (sortSettingPanel.getOrder() < sortSettingPanel2.getOrder()) {
                return -1;
            }
            if (sortSettingPanel2.getOrder() < sortSettingPanel.getOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

