/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class PrettySettingsParser {
    private String filename;
    private LinkedList list = new LinkedList();

    public void setFilename(String string) {
        this.filename = string;
    }

    public void run() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filename));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    this.list.clear();
                } else if (string.charAt(0) == '#') {
                    this.addToDescription(string);
                } else {
                    this.processKey(string);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    private boolean isIndexedOption(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void processKey(String string) throws IOException {
        String string2;
        int n = string.indexOf(61);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1).trim();
        if (string3.equals("version")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
            stringBuffer.append(string2.substring(1));
        }
        stringBuffer.append("Panel");
        string2 = stringBuffer.toString();
        String string5 = "TextPanel";
        String string6 = string4.trim().toLowerCase();
        if (string6.equals("true") || string6.equals("false")) {
            string5 = "TogglePanel";
        } else if (this.containsOption()) {
            string5 = "OptionPanel";
        } else if (this.isIndexedOption(string6)) {
            string5 = "IndexedPanel";
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(string2 + ".java"));
        printWriter.println("package org.acm.seguin.tools.install;");
        printWriter.println("public class " + string2 + " extends " + string5 + "{");
        printWriter.println("\tpublic " + string2 + "() {");
        printWriter.println("\t\tsuper();");
        this.printDescription(printWriter);
        printWriter.println("\t\taddControl();");
        printWriter.println("\t}");
        printWriter.println("\tpublic String getKey() { return \"" + string3 + "\"; }");
        printWriter.println("\tprotected String getInitialValue() { return \"" + string4 + "\"; }");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    private void printDescription(PrintWriter printWriter) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((string = string.trim()).charAt(0) == '*') {
                int n = string.indexOf(45);
                String string2 = string.substring(1, n).trim();
                String string3 = string.substring(n + 1).trim();
                printWriter.println("\t\taddOption(\"" + string2 + "\", \"" + string3 + "\");");
                continue;
            }
            printWriter.println("\t\taddDescription(\"" + string + "\");");
        }
    }

    private boolean containsOption() {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf("*") < 0) continue;
            return true;
        }
        return false;
    }

    private void addToDescription(String string) {
        String string2 = string.substring(1);
        if (string2 != null && string2.trim().length() != 0) {
            this.list.add(string2);
        }
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
        PrettySettingsParser prettySettingsParser = new PrettySettingsParser();
        prettySettingsParser.setFilename(stringArray[0]);
        prettySettingsParser.run();
    }
}

