/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.PrintWriter;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.util.MissingSettingsException;

class AlphabeticalOrderPanel
extends SortSettingPanel {
    public AlphabeticalOrderPanel() {
        this.addDescription("Order methods and fields in alphabetical order");
        this.addListener();
        this.setSortEnabled(this.findProperty("Alphabetical"));
    }

    public void reload() {
        this.setSortEnabled(this.findProperty("Alphabetical"));
    }

    protected String getSortName() {
        return "Alphabetical";
    }

    public void generateSetting(PrintWriter printWriter, int n) {
        this.printDescription(printWriter);
        if (!this.isSortEnabled()) {
            printWriter.print("#");
        }
        printWriter.println("sort." + n + "=Alphabetical()");
        printWriter.println("");
    }

    protected boolean findProperty(String string) {
        try {
            int n = 1;
            while (n < 50) {
                String string2 = SettingPanel.bundle.getString("sort." + n);
                if (string2.startsWith(string)) {
                    this.setOrder(n);
                    return true;
                }
                ++n;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return false;
    }
}

