/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.build;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.acm.seguin.io.DirectoryTreeTraversal;

public class CodeStoreBuilder
extends DirectoryTreeTraversal {
    private LinkedList directoryList = new LinkedList();
    private PrintWriter output;
    private int rootLength;
    private boolean first;
    private String jarFile;
    private int directoryCount;
    private static final int MAX_DIRS = 3;

    public CodeStoreBuilder(String string, String string2, PrintWriter printWriter) {
        super(string2);
        this.output = printWriter;
        this.first = true;
        this.rootLength = string2.length();
        this.jarFile = string;
        this.directoryCount = 0;
    }

    protected boolean isTarget(File file) {
        return file.getName().endsWith(".java");
    }

    protected void visit(File file) {
        String string = file.getParent();
        if (!this.directoryList.contains(string)) {
            this.directoryList.add(string);
            if (this.directoryCount % 3 == 0) {
                if (this.first) {
                    this.output.print("jar cf " + this.jarFile);
                    this.first = false;
                } else {
                    this.output.print("jar uf " + this.jarFile);
                }
            }
            ++this.directoryCount;
            if (string.length() == this.rootLength) {
                this.output.print(" *.java *.html");
            } else {
                this.output.print(" " + string.substring(this.rootLength + 1) + File.separator + "*.java" + " " + string.substring(this.rootLength + 1) + File.separator + "*.html");
            }
            if (this.directoryCount % 3 == 0) {
                this.output.println("");
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "code.jar";
        String string2 = System.getProperty("user.dir");
        PrintWriter printWriter = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            printWriter = stringArray.length > 1 ? new PrintWriter(new FileWriter(stringArray[1])) : new PrintWriter(new OutputStreamWriter(System.out));
        }
        catch (IOException iOException) {
            System.out.println("Unable to create the output file:  " + stringArray[0]);
            return;
        }
        if (stringArray.length > 2) {
            string2 = stringArray[2];
        }
        new CodeStoreBuilder(string, string2, printWriter).go();
        printWriter.println("");
        printWriter.flush();
        printWriter.close();
    }
}

