/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeDeclSummary;

public class TypeSummary
extends Summary {
    private String name = "";
    private boolean bInterface = false;
    private TypeDeclSummary parentClass = null;
    private LinkedList interfaceList = null;
    private LinkedList methodList = null;
    private LinkedList fieldList = null;
    private LinkedList typeList = null;
    private ModifierHolder modifiers;

    public TypeSummary(Summary summary, SimpleNode simpleNode) {
        super(summary);
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isInterface() {
        return this.bInterface;
    }

    public String getName() {
        return this.name;
    }

    public Iterator getMethods() {
        if (this.methodList == null) {
            return null;
        }
        return this.methodList.iterator();
    }

    public int getMethodCount() {
        if (this.methodList == null) {
            return 0;
        }
        return this.methodList.size();
    }

    public Iterator getFields() {
        if (this.fieldList == null) {
            return null;
        }
        return this.fieldList.iterator();
    }

    public int getFieldCount() {
        if (this.fieldList == null) {
            return 0;
        }
        return this.fieldList.size();
    }

    public Iterator getTypes() {
        if (this.typeList == null) {
            return null;
        }
        return this.typeList.iterator();
    }

    public int getTypeCount() {
        if (this.typeList == null) {
            return 0;
        }
        return this.typeList.size();
    }

    public Iterator getImplementedInterfaces() {
        if (this.interfaceList == null) {
            return null;
        }
        return this.interfaceList.iterator();
    }

    public TypeDeclSummary getParentClass() {
        return this.parentClass;
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public PackageSummary getPackageSummary() {
        Summary summary = this.getParent();
        while (summary != null && !(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        return (PackageSummary)summary;
    }

    public FieldSummary getField(String string) {
        Iterator iterator = this.getFields();
        if (iterator != null) {
            while (iterator.hasNext()) {
                FieldSummary fieldSummary = (FieldSummary)iterator.next();
                if (!fieldSummary.getName().equals(string)) continue;
                return fieldSummary;
            }
        }
        return null;
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    public String toString() {
        return this.getName();
    }

    protected void setModifiers(ModifierHolder modifierHolder) {
        this.modifiers = modifierHolder;
    }

    protected void add(MethodSummary methodSummary) {
        if (methodSummary != null) {
            if (this.methodList == null) {
                this.initMethodList();
            }
            this.methodList.add(methodSummary);
        }
    }

    protected void add(FieldSummary fieldSummary) {
        if (fieldSummary != null) {
            if (this.fieldList == null) {
                this.initFieldList();
            }
            this.fieldList.add(fieldSummary);
        }
    }

    protected void add(TypeSummary typeSummary) {
        if (typeSummary != null) {
            if (this.typeList == null) {
                this.initTypeList();
            }
            this.typeList.add(typeSummary);
        }
    }

    protected void add(TypeDeclSummary typeDeclSummary) {
        if (typeDeclSummary != null) {
            if (this.interfaceList == null) {
                this.initInterfaceList();
            }
            this.interfaceList.add(typeDeclSummary);
        }
    }

    void setInterface(boolean bl) {
        this.bInterface = bl;
    }

    void setParentClass(TypeDeclSummary typeDeclSummary) {
        this.parentClass = typeDeclSummary;
    }

    MethodSummary getInitializer(boolean bl) {
        Iterator iterator = this.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MethodSummary methodSummary = (MethodSummary)iterator.next();
                if (!methodSummary.isInitializer() || methodSummary.getModifiers().isStatic() != bl) continue;
                return methodSummary;
            }
        }
        return this.createInitializer(bl);
    }

    private void initInterfaceList() {
        this.interfaceList = new LinkedList();
    }

    private void initMethodList() {
        this.methodList = new LinkedList();
    }

    private void initFieldList() {
        this.fieldList = new LinkedList();
    }

    private void initTypeList() {
        this.typeList = new LinkedList();
    }

    private MethodSummary createInitializer(boolean bl) {
        MethodSummary methodSummary = new MethodSummary(this);
        this.add(methodSummary);
        ModifierHolder modifierHolder = new ModifierHolder();
        if (bl) {
            modifierHolder.add("static");
        }
        modifierHolder.add("private");
        methodSummary.setModifiers(modifierHolder);
        methodSummary.setName("***Initializer***");
        return methodSummary;
    }
}

