/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;

public class ImportSummary
extends Summary {
    private PackageSummary packageSummary;
    private String type;

    public ImportSummary(Summary summary, ASTImportDeclaration aSTImportDeclaration) {
        super(summary);
        ASTName aSTName = (ASTName)aSTImportDeclaration.jjtGetChild(0);
        if (aSTImportDeclaration.isImportingPackage()) {
            this.type = null;
            this.packageSummary = PackageSummary.getPackageSummary(aSTName.getName());
        } else {
            int n = aSTName.getNameSize() - 1;
            this.type = aSTName.getNamePart(n).intern();
            String string = this.getPackageName(n, aSTName);
            this.packageSummary = PackageSummary.getPackageSummary(string);
        }
    }

    public PackageSummary getPackage() {
        return this.packageSummary;
    }

    public String getType() {
        return this.type;
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    private String getPackageName(int n, ASTName aSTName) {
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(aSTName.getNamePart(0));
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(".");
                stringBuffer.append(aSTName.getNamePart(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String toString() {
        if (this.type == null) {
            return "ImportSummary<" + this.packageSummary.getName() + ".*>";
        }
        return "ImportSummary<" + this.packageSummary.getName() + "." + this.type + ">";
    }

    public String getName() {
        return this.type;
    }
}

