/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RemoveImportTransform;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.refactor.type.RenameTypeTransform;
import org.acm.seguin.refactor.type.TypeChangeVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class RenameClassVisitor
extends TypeChangeVisitor {
    protected String packageName;
    protected String oldClassName;
    protected String newClassName;
    private File base;
    private File targetFile;

    public RenameClassVisitor(String string, String string2, String string3, File file, ComplexTransform complexTransform) {
        super(complexTransform);
        this.packageName = string;
        this.base = file;
        this.oldClassName = string2;
        this.newClassName = string3;
    }

    protected TransformAST getFileSpecificTransform(FileSummary fileSummary) {
        if (this.isRenamingTarget(fileSummary)) {
            ASTName aSTName = new ASTName(0);
            aSTName.fromString(this.oldClassName);
            ASTName aSTName2 = new ASTName(0);
            aSTName2.fromString(this.newClassName);
            return new RenameTypeTransform(aSTName, aSTName2, GetTypeSummary.query(this.packageName, this.oldClassName));
        }
        return null;
    }

    protected AddImportTransform getNewImports(FileSummary fileSummary, String string) {
        if (GetTypeSummary.query(fileSummary, this.newClassName) == null) {
            return new AddImportTransform(this.packageName, this.newClassName);
        }
        return null;
    }

    protected RemoveImportTransform getRemoveImportTransform(ImportSummary importSummary) {
        return new RemoveImportTransform(this.packageName, this.oldClassName);
    }

    protected LinkedList getAppropriateClasses(FileSummary fileSummary) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.oldClassName);
        return linkedList;
    }

    protected File getNewFile(FileSummary fileSummary) {
        File file = this.base;
        StringTokenizer stringTokenizer = new StringTokenizer(this.packageName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            file = new File(file, stringTokenizer.nextToken());
        }
        File file2 = new File(file, this.oldClassName + ".java");
        if (this.checkFiles(file2, fileSummary.getFile())) {
            File file3 = new File(file, this.newClassName + ".java");
            return file3;
        }
        return fileSummary.getFile();
    }

    protected String getCurrentPackage() {
        return this.packageName;
    }

    protected ASTName getNewName() {
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(this.packageName);
        aSTName.addNamePart(this.newClassName);
        return aSTName;
    }

    protected void addRenamingTransforms(ComplexTransform complexTransform, FileSummary fileSummary, String string) {
        ASTName aSTName = new ASTName(0);
        aSTName.addNamePart(this.oldClassName);
        TypeSummary typeSummary = GetTypeSummary.query(fileSummary, this.newClassName);
        if (typeSummary != null && this.isRenamingTarget(fileSummary)) {
            this.renameRefactoringTarget(complexTransform, fileSummary, string, aSTName, typeSummary);
        } else if (typeSummary != null) {
            this.alreadyImportsType(complexTransform, aSTName, fileSummary, typeSummary);
        } else {
            this.simpleRename(complexTransform, aSTName);
        }
        complexTransform.add(new RenameTypeTransform(this.getOldName(), this.getNewName(), GetTypeSummary.query(this.packageName, this.oldClassName)));
    }

    protected void alreadyImportsType(ComplexTransform complexTransform, ASTName aSTName, FileSummary fileSummary, TypeSummary typeSummary) {
        complexTransform.add(new RenameTypeTransform(aSTName, this.getNewName(), GetTypeSummary.query(this.packageName, this.oldClassName)));
    }

    private boolean isRenamingTarget(FileSummary fileSummary) {
        if (this.targetFile == null) {
            File file = this.base;
            StringTokenizer stringTokenizer = new StringTokenizer(this.packageName, ".");
            while (stringTokenizer.hasMoreTokens()) {
                file = new File(file, stringTokenizer.nextToken());
            }
            this.targetFile = new File(file, this.oldClassName + ".java");
        }
        return this.checkFiles(this.targetFile, fileSummary.getFile());
    }

    private ASTName getImport(TypeSummary typeSummary) {
        ASTName aSTName = new ASTName(0);
        Summary summary = typeSummary.getParent();
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        aSTName.fromString(((PackageSummary)summary).getName());
        aSTName.addNamePart(typeSummary.getName());
        return aSTName;
    }

    private ASTName getOldName() {
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(this.packageName);
        aSTName.addNamePart(this.oldClassName);
        return aSTName;
    }

    private void simpleRename(ComplexTransform complexTransform, ASTName aSTName) {
        ASTName aSTName2 = new ASTName(0);
        aSTName2.addNamePart(this.newClassName);
        complexTransform.add(new RenameTypeTransform(aSTName, aSTName2, GetTypeSummary.query(this.packageName, this.oldClassName)));
    }

    private void renameRefactoringTarget(ComplexTransform complexTransform, FileSummary fileSummary, String string, ASTName aSTName, TypeSummary typeSummary) {
        ASTName aSTName2 = new ASTName(0);
        aSTName2.addNamePart(this.newClassName);
        ASTName aSTName3 = this.getImport(typeSummary);
        complexTransform.add(new RenameTypeTransform(aSTName2, aSTName3, GetTypeSummary.query(this.packageName, this.oldClassName)));
        complexTransform.add(new RemoveImportTransform(aSTName3));
        complexTransform.add(new RenameTypeTransform(aSTName, aSTName2, GetTypeSummary.query(this.packageName, this.oldClassName)));
    }

    private boolean checkFiles(File file, File file2) {
        try {
            String string = file.getCanonicalPath();
            String string2 = file2.getCanonicalPath();
            return string.equals(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

