/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.ASTInterfaceBody;
import org.acm.seguin.parser.ast.ASTInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedInterfaceDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.TopLevelDirectory;

public class CreateNewInterface {
    private String m_interfaceName;
    private String m_packageName;
    private Summary m_summary;

    public CreateNewInterface(Summary summary, String string, String string2) {
        this.m_summary = summary;
        this.m_packageName = string;
        this.m_interfaceName = string2;
    }

    CreateNewInterface() {
        this.m_interfaceName = null;
        this.m_packageName = null;
    }

    public File run() throws RefactoringException {
        SimpleNode simpleNode;
        if (this.m_packageName == null) {
            throw new RefactoringException("No package name specified");
        }
        if (this.m_interfaceName == null) {
            throw new RefactoringException("No interface name specified");
        }
        ASTCompilationUnit aSTCompilationUnit = new ASTCompilationUnit(0);
        int n = 0;
        if (this.m_packageName != null && this.m_packageName.length() > 0) {
            simpleNode = this.createPackageDeclaration();
            aSTCompilationUnit.jjtAddChild(simpleNode, 0);
            ++n;
        }
        simpleNode = new ASTName(0);
        ASTTypeDeclaration aSTTypeDeclaration = this.createTypeDeclaration();
        aSTCompilationUnit.jjtAddChild(aSTTypeDeclaration, n);
        File file = this.print(this.m_interfaceName, aSTCompilationUnit);
        return file;
    }

    ASTPackageDeclaration createPackageDeclaration() {
        ASTPackageDeclaration aSTPackageDeclaration = new ASTPackageDeclaration(0);
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(this.m_packageName);
        aSTPackageDeclaration.jjtAddChild(aSTName, 0);
        return aSTPackageDeclaration;
    }

    ASTTypeDeclaration createTypeDeclaration() {
        ASTTypeDeclaration aSTTypeDeclaration = new ASTTypeDeclaration(0);
        ASTInterfaceDeclaration aSTInterfaceDeclaration = this.createModifiedClass();
        aSTTypeDeclaration.jjtAddChild(aSTInterfaceDeclaration, 0);
        return aSTTypeDeclaration;
    }

    ASTInterfaceDeclaration createModifiedClass() {
        ASTInterfaceDeclaration aSTInterfaceDeclaration = new ASTInterfaceDeclaration(0);
        aSTInterfaceDeclaration.addModifier("public");
        ASTUnmodifiedInterfaceDeclaration aSTUnmodifiedInterfaceDeclaration = this.createClassBody(this.m_interfaceName);
        aSTInterfaceDeclaration.jjtAddChild(aSTUnmodifiedInterfaceDeclaration, 0);
        return aSTInterfaceDeclaration;
    }

    ASTUnmodifiedInterfaceDeclaration createClassBody(String string) {
        ASTUnmodifiedInterfaceDeclaration aSTUnmodifiedInterfaceDeclaration = new ASTUnmodifiedInterfaceDeclaration(0);
        aSTUnmodifiedInterfaceDeclaration.setName(string);
        ASTInterfaceBody aSTInterfaceBody = new ASTInterfaceBody(0);
        aSTUnmodifiedInterfaceDeclaration.jjtAddChild(aSTInterfaceBody, 0);
        return aSTUnmodifiedInterfaceDeclaration;
    }

    File print(String string, SimpleNode simpleNode) {
        File file = TopLevelDirectory.getPackageDirectory(this.m_summary, this.m_packageName);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, string + ".java");
        try {
            new PrettyPrintFile().apply(file2, simpleNode);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        return file2;
    }

    private PackageSummary getPackageSummary(Summary summary) {
        Summary summary2 = summary;
        while (!(summary2 instanceof PackageSummary)) {
            summary2 = summary2.getParent();
        }
        return (PackageSummary)summary2;
    }

    private boolean isSameParent(TypeSummary typeSummary, TypeSummary typeSummary2) {
        if (this.isObject(typeSummary)) {
            return this.isObject(typeSummary2);
        }
        if (this.isObject(typeSummary2)) {
            return false;
        }
        return typeSummary.equals(typeSummary2);
    }

    private boolean isObject(TypeSummary typeSummary) {
        if (typeSummary == null) {
            return true;
        }
        return typeSummary.getName().equals("Object");
    }
}

