/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.util.Enumeration;
import java.util.Vector;
import org.acm.seguin.refactor.EliminatePackageImportVisitor;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TraversalVisitor;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public abstract class AddClassRefactoring
extends Refactoring {
    private Vector summaryList = new Vector();
    private String className = null;

    protected void setNewClassName(String string) {
        this.className = string;
    }

    protected String getNewClassName() {
        return this.className;
    }

    protected void addTargetClass(TypeSummary typeSummary) {
        if (typeSummary != null) {
            this.summaryList.addElement(typeSummary);
        }
    }

    protected void preconditions() throws RefactoringException {
        if (this.summaryList.size() == 0) {
            throw new RefactoringException("Unable to find type to extend");
        }
        if (this.className == null) {
            throw new RefactoringException("New class name is not specified");
        }
        PackageSummary packageSummary = this.getPackageSummary((Summary)this.summaryList.elementAt(0));
        TypeSummary typeSummary = GetTypeSummary.query(packageSummary, this.className);
        if (typeSummary != null) {
            throw new RefactoringException("Type with that name already exists");
        }
        TypeSummary typeSummary2 = (TypeSummary)this.summaryList.elementAt(0);
        TypeSummary typeSummary3 = GetTypeSummary.query(typeSummary2.getParentClass());
        Enumeration enumeration = this.summaryList.elements();
        while (enumeration.hasMoreElements()) {
            TypeSummary typeSummary4 = (TypeSummary)enumeration.nextElement();
            if (typeSummary4.isInterface()) {
                throw new RefactoringException("This refactoring only works for classes, not interfaces");
            }
            FileSummary fileSummary = (FileSummary)typeSummary4.getParent();
            TypeSummary typeSummary5 = GetTypeSummary.query(fileSummary, this.className);
            if (typeSummary5 != null) {
                throw new RefactoringException("New class already exists relative to " + typeSummary4.getName());
            }
            if (this.isSameParent(typeSummary3, GetTypeSummary.query(typeSummary4.getParentClass()))) continue;
            throw new RefactoringException("Existing types don't share the same original parent");
        }
    }

    protected void transform() {
        Object object;
        Enumeration enumeration = this.summaryList.elements();
        while (enumeration.hasMoreElements()) {
            object = (TypeSummary)enumeration.nextElement();
            this.transformOriginal((TypeSummary)object);
        }
        this.createClass((TypeSummary)this.summaryList.elementAt(0), this.className);
        object = new EliminatePackageImportVisitor(this.getComplexTransform());
        ((EliminatePackageImportVisitor)object).setPackageSummary(this.getPackageSummary((Summary)this.summaryList.elementAt(0)));
        ((TraversalVisitor)object).visit(null);
    }

    protected abstract void createClass(TypeSummary var1, String var2);

    protected abstract void transformOriginal(TypeSummary var1);

    private PackageSummary getPackageSummary(Summary summary) {
        Summary summary2 = summary;
        while (!(summary2 instanceof PackageSummary)) {
            summary2 = summary2.getParent();
        }
        return (PackageSummary)summary2;
    }

    private boolean isSameParent(TypeSummary typeSummary, TypeSummary typeSummary2) {
        if (this.isObject(typeSummary)) {
            return this.isObject(typeSummary2);
        }
        if (this.isObject(typeSummary2)) {
            return false;
        }
        return typeSummary.equals(typeSummary2);
    }

    private boolean isObject(TypeSummary typeSummary) {
        if (typeSummary == null) {
            return true;
        }
        return typeSummary.getName().equals("Object");
    }
}

