/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.RenameParameterTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;

public class RenameParameterRefactoring
extends Refactoring {
    private String newName = null;
    private ParameterSummary param = null;
    private MethodSummary method = null;

    protected RenameParameterRefactoring() {
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public void setParameterSummary(ParameterSummary parameterSummary) {
        this.param = parameterSummary;
    }

    public void setMethodSummary(MethodSummary methodSummary) {
        this.method = methodSummary;
    }

    public String getDescription() {
        return "Renaming " + this.param.getName() + " to " + this.newName + " in " + this.method.toString();
    }

    public int getID() {
        return 251;
    }

    protected void preconditions() throws RefactoringException {
        if (this.newName == null || this.newName.length() == 0) {
            throw new RefactoringException("No new name specified");
        }
        if (this.param == null) {
            throw new RefactoringException("No parameter specified");
        }
        if (this.method == null) {
            throw new RefactoringException("No method specified");
        }
    }

    protected void transform() {
        ComplexTransform complexTransform = this.getComplexTransform();
        RenameParameterTransform renameParameterTransform = new RenameParameterTransform();
        renameParameterTransform.setMethod(this.method);
        renameParameterTransform.setParameter(this.param);
        renameParameterTransform.setNewName(this.newName);
        complexTransform.add(renameParameterTransform);
        Summary summary = this.method;
        while (!(summary instanceof FileSummary)) {
            summary = summary.getParent();
        }
        FileSummary fileSummary = (FileSummary)summary;
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
    }
}

