/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTBlockStatement;
import org.acm.seguin.parser.ast.ASTClassBody;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTClassDeclaration;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTReturnStatement;
import org.acm.seguin.parser.ast.ASTStatement;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedClassDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.build.BuildExpression;
import org.acm.seguin.parser.factory.BufferParserFactory;
import org.acm.seguin.parser.query.Found;
import org.acm.seguin.parser.query.Search;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.PrettyPrintVisitor;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.EMBuilder;
import org.acm.seguin.refactor.method.EMDigger;
import org.acm.seguin.refactor.method.EMParameterFinder;
import org.acm.seguin.refactor.method.FindLocalVariableDeclVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.SummaryLoadVisitor;
import org.acm.seguin.summary.SummaryLoaderState;
import org.acm.seguin.summary.VariableSummary;

public class ExtractMethodRefactoring
extends Refactoring {
    private StringBuffer fullFile = null;
    private String selection = null;
    private String methodName = null;
    private SimpleNode root;
    private FileSummary mainFileSummary;
    private FileSummary extractedMethodFileSummary;
    private Node key;
    private EMParameterFinder empf = null;
    private StringBuffer signature;
    private Object returnType = null;
    private int prot = 0;
    private Object[] arguments = new Object[0];
    public static final int PRIVATE = 0;
    public static final int PACKAGE = 1;
    public static final int PROTECTED = 2;
    public static final int PUBLIC = 3;

    protected ExtractMethodRefactoring() {
        this.signature = new StringBuffer();
    }

    public void setFullFile(String string) {
        this.fullFile = new StringBuffer(string);
    }

    public void setFullFile(StringBuffer stringBuffer) {
        this.fullFile = stringBuffer;
    }

    public void setSelection(String string) throws RefactoringException {
        if (string == null) {
            throw new RefactoringException("Nothing has been selected, so nothing can be extracted");
        }
        this.selection = string.trim();
        if (this.isStatement()) {
            this.setReturnType(null);
        } else {
            this.setReturnType("boolean");
        }
    }

    public void setMethodName(String string) {
        this.methodName = string;
        if (this.methodName == null || this.methodName.length() == 0) {
            this.methodName = "extractedMethod";
        }
    }

    public void setParameterOrder(Object[] objectArray) {
        this.empf.setParameterOrder(objectArray);
        this.arguments = objectArray;
    }

    public void setProtection(int n) {
        this.prot = n;
    }

    public void setReturnType(Object object) {
        this.returnType = object;
    }

    public String getDescription() {
        return "Extract a method named " + this.methodName;
    }

    public String getFullFile() {
        return this.fullFile.toString();
    }

    public VariableSummary[] getParameters() throws RefactoringException {
        this.preconditions();
        Search search = new Search();
        this.empf = this.prescan(search);
        LinkedList linkedList = this.empf.getList();
        VariableSummary[] variableSummaryArray = new VariableSummary[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            variableSummaryArray[n] = (VariableSummary)iterator.next();
            ++n;
        }
        this.arguments = variableSummaryArray;
        return variableSummaryArray;
    }

    public Object[] getReturnTypes() throws RefactoringException {
        if (this.empf == null) {
            return null;
        }
        return this.empf.getReturnTypes();
    }

    public boolean isStatement() {
        return this.selection.indexOf(";") > 0 || this.selection.indexOf("}") > 0;
    }

    public String getSignature() {
        this.signature.setLength(0);
        this.signature.append(this.getProtection());
        this.signature.append(" ");
        this.signature.append(this.getReturnTypeString());
        this.signature.append(" ");
        this.signature.append(this.methodName);
        this.signature.append("(");
        int n = 0;
        while (n < this.arguments.length) {
            this.signature.append(((VariableSummary)this.arguments[n]).getDeclaration());
            if (n != this.arguments.length - 1) {
                this.signature.append(", ");
            }
            ++n;
        }
        this.signature.append(")");
        return this.signature.toString();
    }

    public Object getReturnType() {
        return this.returnType;
    }

    public int getID() {
        return 205;
    }

    protected void preconditions() throws RefactoringException {
        if (this.fullFile == null) {
            throw new RefactoringException("No file specified");
        }
        if (this.selection == null) {
            throw new RefactoringException("No selection specified");
        }
        if (this.methodName == null) {
            throw new RefactoringException("No method specified");
        }
        this.root = this.getFileRoot();
        if (this.root == null) {
            throw new RefactoringException("Unable to parse the current file.\nPlease make sure you can compile this file before\ntrying to extract a method from it.");
        }
        this.mainFileSummary = this.findVariablesUsed(this.root);
        SimpleNode simpleNode = this.getMethodTree();
        if (simpleNode == null) {
            throw new RefactoringException("Unable to parse the current selection.\nPlease make sure you have highlighted the entire expression\nor set of statements.");
        }
    }

    protected void transform() {
        this.replaceAllInstances(this.root);
        this.printFile(this.root);
    }

    private SimpleNode getMethodTree() {
        String string = "public class TempClass { " + this.makeMethod() + "}";
        BufferParserFactory bufferParserFactory = new BufferParserFactory(string);
        SimpleNode simpleNode = bufferParserFactory.getAbstractSyntaxTree(false);
        this.extractedMethodFileSummary = this.findVariablesUsed(simpleNode);
        ASTTypeDeclaration aSTTypeDeclaration = (ASTTypeDeclaration)simpleNode.jjtGetChild(0);
        ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTTypeDeclaration.jjtGetChild(0);
        ASTUnmodifiedClassDeclaration aSTUnmodifiedClassDeclaration = (ASTUnmodifiedClassDeclaration)aSTClassDeclaration.jjtGetChild(0);
        ASTClassBody aSTClassBody = (ASTClassBody)aSTUnmodifiedClassDeclaration.jjtGetChild(0);
        ASTClassBodyDeclaration aSTClassBodyDeclaration = (ASTClassBodyDeclaration)aSTClassBody.jjtGetChild(0);
        return (SimpleNode)aSTClassBodyDeclaration.jjtGetChild(0);
    }

    private SimpleNode getFileRoot() {
        BufferParserFactory bufferParserFactory = new BufferParserFactory(this.fullFile.toString());
        SimpleNode simpleNode = bufferParserFactory.getAbstractSyntaxTree(true);
        return simpleNode;
    }

    private String getProtection() {
        switch (this.prot) {
            case 0: {
                return "private";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "public";
            }
        }
        return "private";
    }

    private String getReturnTypeString() {
        if (this.returnType == null) {
            return "void";
        }
        if (this.returnType instanceof String) {
            return (String)this.returnType;
        }
        if (this.returnType instanceof VariableSummary) {
            return ((VariableSummary)this.returnType).getTypeDecl().getName();
        }
        return this.returnType.toString();
    }

    private void replaceAllInstances(SimpleNode simpleNode) {
        Object object;
        EMBuilder eMBuilder = new EMBuilder();
        eMBuilder.setMethodName(this.methodName);
        eMBuilder.setStatement(this.isStatement());
        Search search = new Search();
        if (this.empf == null) {
            this.empf = this.prescan(search);
        }
        eMBuilder.setParameters(this.empf.getList());
        SimpleNode simpleNode2 = this.addReturn(this.getMethodTree());
        Found found = search.search(simpleNode, this.key);
        this.updateModifiers((SimpleNode)found.getRoot(), simpleNode2);
        if (this.returnType instanceof VariableSummary) {
            eMBuilder.setReturnSummary((VariableSummary)this.returnType);
            object = new FindLocalVariableDeclVisitor();
            simpleNode2.jjtAccept((JavaParserVisitor)object, this.returnType);
            eMBuilder.setLocalVariableNeeded(((FindLocalVariableDeclVisitor)object).isFound());
        }
        object = (SimpleNode)found.getRoot();
        while (found != null) {
            this.replaceExtractedMethod(found, eMBuilder);
            found = search.search(simpleNode, this.key);
        }
        this.insertAtNextClass((SimpleNode)object, simpleNode2);
    }

    private void printFile(SimpleNode simpleNode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JavadocTags.get().reload();
        PrintData printData = new PrintData(byteArrayOutputStream);
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        prettyPrintVisitor.visit((ASTCompilationUnit)simpleNode, (Object)printData);
        printData.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = new String(byArray);
        if (string.length() > 0) {
            this.fullFile = new StringBuffer(string);
        }
    }

    private String makeMethod() {
        if (this.isStatement()) {
            return this.getSignature() + "{" + this.selection + "}";
        }
        return this.getSignature() + "{ return " + this.selection + "; }";
    }

    private FileSummary findVariablesUsed(Node node) {
        if (node == null) {
            return null;
        }
        SummaryLoaderState summaryLoaderState = new SummaryLoaderState();
        node.jjtAccept(new SummaryLoadVisitor(), summaryLoaderState);
        return (FileSummary)summaryLoaderState.getCurrentSummary();
    }

    private EMParameterFinder findParameters(Found found) {
        EMParameterFinder eMParameterFinder = new EMParameterFinder();
        eMParameterFinder.setMainFileSummary(this.mainFileSummary);
        eMParameterFinder.setExtractFileSummary(this.extractedMethodFileSummary);
        eMParameterFinder.setLocation(found.getRoot());
        eMParameterFinder.run();
        return eMParameterFinder;
    }

    private EMParameterFinder prescan(Search search) {
        EMDigger eMDigger = new EMDigger();
        this.key = this.isStatement() ? eMDigger.last((ASTMethodDeclaration)this.getMethodTree()) : eMDigger.dig((ASTMethodDeclaration)this.getMethodTree());
        Found found = search.search(this.root, this.key);
        EMParameterFinder eMParameterFinder = this.findParameters(found);
        LinkedList linkedList = eMParameterFinder.getList();
        this.arguments = new Object[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.arguments[n] = iterator.next();
            ++n;
        }
        return eMParameterFinder;
    }

    private void replaceExtractedMethod(Found found, EMBuilder eMBuilder) {
        int n = found.getIndex();
        int n2 = this.key.jjtGetNumChildren();
        Node node = found.getRoot();
        int n3 = 0;
        while (n3 < n2) {
            node.jjtDeleteChild(n);
            ++n3;
        }
        node.jjtInsertChild(eMBuilder.build(), n);
    }

    private SimpleNode addReturn(SimpleNode simpleNode) {
        if (this.returnType instanceof VariableSummary) {
            Node node = simpleNode.jjtGetChild(simpleNode.jjtGetNumChildren() - 1);
            ASTBlockStatement aSTBlockStatement = new ASTBlockStatement(0);
            ASTStatement aSTStatement = new ASTStatement(0);
            aSTBlockStatement.jjtAddChild(aSTStatement, 0);
            ASTReturnStatement aSTReturnStatement = new ASTReturnStatement(0);
            aSTStatement.jjtAddChild(aSTReturnStatement, 0);
            BuildExpression buildExpression = new BuildExpression();
            String string = ((VariableSummary)this.returnType).getName();
            aSTReturnStatement.jjtAddChild(buildExpression.buildName(string), 0);
            node.jjtAddChild(aSTBlockStatement, node.jjtGetNumChildren());
        }
        return simpleNode;
    }

    private void updateModifiers(SimpleNode simpleNode, SimpleNode simpleNode2) {
        while (!(simpleNode instanceof ASTMethodDeclaration)) {
            if (!((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) instanceof ASTClassBody)) continue;
            return;
        }
        ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)simpleNode;
        ASTMethodDeclaration aSTMethodDeclaration2 = (ASTMethodDeclaration)simpleNode2;
        ModifierHolder modifierHolder = aSTMethodDeclaration.getModifiers();
        ModifierHolder modifierHolder2 = aSTMethodDeclaration2.getModifiers();
        modifierHolder2.setStatic(modifierHolder.isStatic());
        modifierHolder2.setSynchronized(modifierHolder2.isSynchronized());
    }

    private void insertAtNextClass(SimpleNode simpleNode, SimpleNode simpleNode2) {
        while (!(simpleNode instanceof ASTClassBody)) {
            if ((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null) continue;
            return;
        }
        simpleNode.jjtInsertChild(simpleNode2, simpleNode.jjtGetNumChildren());
    }
}

