/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.undo.UndoAction;
import org.acm.seguin.refactor.undo.UndoStack;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.util.FileSettings;

public abstract class Refactoring {
    private ComplexTransform complex = null;
    public static final int REPACKAGE = 1;
    public static final int RENAME_CLASS = 2;
    public static final int ADD_CHILD = 4;
    public static final int ADD_PARENT = 3;
    public static final int REMOVE_CLASS = 5;
    public static final int EXTRACT_INTERFACE = 6;
    public static final int PUSH_DOWN_FIELD = 101;
    public static final int PUSH_UP_FIELD = 102;
    public static final int RENAME_FIELD = 103;
    public static final int PUSH_UP_METHOD = 201;
    public static final int PUSH_UP_ABSTRACT_METHOD = 202;
    public static final int PUSH_DOWN_METHOD = 203;
    public static final int MOVE_METHOD = 204;
    public static final int EXTRACT_METHOD = 205;
    public static final int RENAME_METHOD = 206;
    public static final int RENAME_PARAMETER = 251;

    public abstract String getDescription();

    public abstract int getID();

    public void run() throws RefactoringException {
        try {
            this.preconditions();
            this.transform();
            UndoStack.get().done();
            this.recordUsage();
        }
        catch (RefactoringException refactoringException) {
            throw refactoringException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
    }

    protected ComplexTransform getComplexTransform() {
        if (this.complex == null) {
            UndoAction undoAction = UndoStack.get().add(this);
            this.complex = new ComplexTransform(undoAction);
        }
        return this.complex;
    }

    protected abstract void preconditions() throws RefactoringException;

    protected abstract void transform();

    protected void checkDestinationFile(Summary summary, String string) throws RefactoringException {
        while (summary != null) {
            if (summary instanceof FileSummary) {
                FileSummary fileSummary = (FileSummary)summary;
                if (fileSummary.getFile() == null) {
                    throw new RefactoringException(string);
                }
                summary = null;
                continue;
            }
            summary = summary.getParent();
        }
    }

    private void recordUsage() {
        try {
            String string = FileSettings.getSettingsRoot();
            FileWriter fileWriter = new FileWriter(string + File.separator + ".Refactory" + File.separator + "log.txt", true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            printWriter.println(this.getID() + ", " + dateFormat.format(new Date()));
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

