/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RemoveImportTransform;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.refactor.type.TypeChangeVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeSummary;

public class EliminatePackageImportVisitor
extends TypeChangeVisitor {
    private PackageSummary packageSummary;
    private LinkedList filterList = new LinkedList();

    public EliminatePackageImportVisitor(ComplexTransform complexTransform) {
        super(complexTransform);
    }

    public void setPackageSummary(PackageSummary packageSummary) {
        this.packageSummary = packageSummary;
    }

    public void addFilterClass(String string) {
        this.filterList.add(string);
    }

    protected TransformAST getFileSpecificTransform(FileSummary fileSummary) {
        return new RemoveImportTransform(this.packageSummary);
    }

    protected AddImportTransform getNewImports(FileSummary fileSummary, String string) {
        return new AddImportTransform(this.packageSummary.getName(), string);
    }

    protected RemoveImportTransform getRemoveImportTransform(ImportSummary importSummary) {
        return null;
    }

    protected LinkedList getAppropriateClasses(FileSummary fileSummary) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.packageSummary.getFileSummaries();
        if (iterator != null) {
            while (iterator.hasNext()) {
                FileSummary fileSummary2 = (FileSummary)iterator.next();
                this.addTypesFromFile(fileSummary2, linkedList);
            }
        }
        return linkedList;
    }

    protected File getNewFile(FileSummary fileSummary) {
        return fileSummary.getFile();
    }

    protected String getCurrentPackage() {
        return this.packageSummary.getName();
    }

    protected boolean preconditions(FileSummary fileSummary) {
        if (fileSummary.getParent() == this.packageSummary) {
            return false;
        }
        Iterator iterator = fileSummary.getImports();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ImportSummary importSummary = (ImportSummary)iterator.next();
                if (!this.isImportingPackage(importSummary)) continue;
                return true;
            }
        }
        return false;
    }

    protected void addRenamingTransforms(ComplexTransform complexTransform, FileSummary fileSummary, String string) {
    }

    private boolean isInFilter(TypeSummary typeSummary) {
        Iterator iterator = this.filterList.iterator();
        String string = typeSummary.getName();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isImportingPackage(ImportSummary importSummary) {
        return importSummary.getType() == null && importSummary.getPackage() == this.packageSummary;
    }

    private void addTypesFromFile(FileSummary fileSummary, LinkedList linkedList) {
        Iterator iterator = fileSummary.getTypes();
        if (iterator != null) {
            while (iterator.hasNext()) {
                TypeSummary typeSummary = (TypeSummary)iterator.next();
                if (!typeSummary.getModifiers().isPublic() || this.isInFilter(typeSummary)) continue;
                linkedList.add(typeSummary.getName());
            }
        }
    }
}

