/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import org.acm.seguin.print.PagePrinter;
import org.acm.seguin.print.PrintingSettings;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.LineSet;

public class TextPagePrinter
extends PagePrinter {
    private String filename;
    private LineSet lineSet;
    private LinePrinter linePrinter;
    private int textFontSize = 10;
    private int textSkip = 2;
    private static int linesPerPage = -1;

    public TextPagePrinter(String string, String string2, LinePrinter linePrinter) {
        this.lineSet = new LineSet(string2);
        this.linePrinter = linePrinter;
        this.filename = string;
    }

    public void setTextFontSize(int n) {
        this.textFontSize = n;
    }

    public void setBetweenLineSpacing(int n) {
        this.textSkip = n;
    }

    public int calculatePageCount(PageFormat pageFormat) {
        int n = (int)pageFormat.getImageableHeight();
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = linesPerPage;
        int n4 = this.lineSet.size();
        if (linesPerPage == -1) {
            PrintingSettings printingSettings = new PrintingSettings();
            n3 = printingSettings.getLinesPerPage();
        }
        int n5 = n4 / n3;
        if (n4 % n3 != 0) {
            ++n5;
        }
        return n5;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3 = this.calculatePageCount(pageFormat);
        if (n > n3) {
            return 1;
        }
        this.linePrinter.setFontSize(this.textFontSize);
        int n4 = this.linePrinter.getLineHeight(graphics) + this.textSkip;
        if (linesPerPage == -1) {
            n2 = (int)pageFormat.getImageableHeight() - PagePrinter.headerHeight;
            linesPerPage = n2 / n4;
            PrintingSettings printingSettings = new PrintingSettings();
            printingSettings.setLinesPerPage(linesPerPage);
        }
        n2 = n * linesPerPage;
        int n5 = (int)pageFormat.getImageableX();
        int n6 = (int)pageFormat.getImageableY() + PagePrinter.headerHeight;
        this.printHeader(graphics, this.filename, "" + (1 + n), "" + n3);
        this.linePrinter.init(graphics);
        int n7 = 0;
        while (n7 < linesPerPage) {
            int n8 = n7 + n * linesPerPage;
            String string = this.lineSet.getLine(n8);
            if (string == null) break;
            this.linePrinter.print(graphics, string, n5, n6 + (1 + n7) * n4, this.lineSet, n8);
            ++n7;
        }
        return 0;
    }
}

