/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.print.PagePrinter;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.TextPagePrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrintingThread
extends Thread {
    private String data;
    private LinePrinter printer;
    private String filename;

    public PrintingThread(String string, String string2, LinePrinter linePrinter) {
        this.data = string2;
        this.printer = linePrinter;
        this.filename = string;
    }

    public void run() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        TextPagePrinter textPagePrinter = new TextPagePrinter(this.filename, this.data, this.printer);
        this.loadDefaults(textPagePrinter);
        PageFormat pageFormat = PagePrinter.getPageFormat(false);
        if (pageFormat == null) {
            pageFormat = PagePrinter.getPageFormat(true);
        }
        int n = textPagePrinter.calculatePageCount(pageFormat);
        book.append(textPagePrinter, pageFormat, n);
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Throwable throwable) {
                ExceptionPrinter.print(throwable, false);
            }
        }
    }

    private void loadDefaults(TextPagePrinter textPagePrinter) {
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "printing");
            textPagePrinter.setTextFontSize(Integer.parseInt(fileSettings.getString("text.font.size")));
            textPagePrinter.setBetweenLineSpacing(Integer.parseInt(fileSettings.getString("text.space")));
            textPagePrinter.setFilenameFontSize(Integer.parseInt(fileSettings.getString("filename.font.size")));
            textPagePrinter.setDatePageCountFontSize(Integer.parseInt(fileSettings.getString("date.font.size")));
        }
        catch (MissingSettingsException missingSettingsException) {
            ExceptionPrinter.print(missingSettingsException, false);
        }
        catch (NumberFormatException numberFormatException) {
            ExceptionPrinter.print(numberFormatException, false);
        }
    }

    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            new PrintingThread(stringArray[0], stringBuffer.toString(), new LinePrinter()).run();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }
}

