/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public abstract class PagePrinter
implements Printable {
    private int filenameFontSize = 14;
    private int datePageFontSize = 8;
    protected static int headerHeight = 30;
    protected static PageFormat pf;
    private static double scale;

    public void setFilenameFontSize(int n) {
        this.filenameFontSize = n;
    }

    public void setDatePageCountFontSize(int n) {
        this.datePageFontSize = n;
    }

    protected void printHeader(Graphics graphics, String string, String string2, String string3) {
        int n = (int)pf.getImageableX();
        int n2 = (int)pf.getImageableY();
        int n3 = (int)pf.getImageableWidth();
        int n4 = headerHeight;
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        int n5 = n3 / 4;
        graphics.drawLine(n + 2 * n5, n2, n + 2 * n5, n2 + headerHeight - 1);
        graphics.drawLine(n + 3 * n5, n2, n + 3 * n5, n2 + headerHeight - 1);
        int n6 = n2 + headerHeight / 2;
        graphics.setFont(new Font("Serif", 1, this.filenameFontSize));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = n2 + (headerHeight + fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 - fontMetrics.getDescent();
        if (string != null && string.length() > 0) {
            graphics.drawString(string, n + 10, n7);
        }
        graphics.setFont(new Font("Serif", 1, this.datePageFontSize));
        fontMetrics = graphics.getFontMetrics();
        String string4 = DateFormat.getDateTimeInstance().format(new Date());
        n7 = n2 + (headerHeight + fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 - fontMetrics.getDescent();
        graphics.drawString(string4, n + 5 * n5 / 2 - fontMetrics.stringWidth(string4) / 2, n7);
        String string5 = string2 + " of " + string3;
        graphics.drawString(string5, n + 7 * n5 / 2 - fontMetrics.stringWidth(string5) / 2, n7);
    }

    public static void setHeaderHeight(int n) {
        headerHeight = n;
    }

    public static PageFormat getPageFormat(boolean bl) {
        Object object;
        if (bl) {
            object = PrinterJob.getPrinterJob();
            pf = ((PrinterJob)object).pageDialog(((PrinterJob)object).defaultPage());
        }
        try {
            object = FileSettings.getSettings("Refactory", "printing");
            PagePrinter.setHeaderHeight(Integer.parseInt(((FileSettings)object).getString("header.space")));
        }
        catch (MissingSettingsException missingSettingsException) {
            ExceptionPrinter.print(missingSettingsException, true);
        }
        catch (NumberFormatException numberFormatException) {
            ExceptionPrinter.print(numberFormatException, true);
        }
        return pf;
    }

    public static int getPageWidth() {
        if (pf == null) {
            return -1;
        }
        return (int)(pf.getImageableWidth() / scale);
    }

    public static int getPageHeight() {
        if (pf == null) {
            return -1;
        }
        return (int)(pf.getImageableHeight() / scale);
    }

    protected static void setScale(double d) {
        scale = d;
    }

    protected static double getScale() {
        return scale;
    }

    public abstract int print(Graphics var1, PageFormat var2, int var3) throws PrinterException;

    static {
        scale = 1.0;
    }
}

