/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class JavadocTags {
    private boolean debug = false;
    private String exceptionDescr = "";
    private String exceptionTag;
    private String paramDescr = "";
    private String returnDescr = "";
    private String constructorDescr;
    private static JavadocTags singleton = null;

    private JavadocTags() {
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setExceptionDescr(String string) {
        this.exceptionDescr = string == null ? "" : string;
    }

    public void setExceptionTag(String string) {
        this.exceptionTag = string == null || string.length() == 0 || string.equals("@") ? "exception" : (string.charAt(0) == '@' ? string.substring(1) : string);
    }

    public void setParamDescr(String string) {
        this.paramDescr = string == null ? "" : string;
    }

    public void setReturnDescr(String string) {
        this.returnDescr = string == null ? "" : string;
    }

    public String getExceptionDescr() {
        return this.exceptionDescr;
    }

    public String getExceptionTag() {
        return "@" + this.exceptionTag;
    }

    public String getParamDescr() {
        return this.paramDescr;
    }

    public String getReturnDescr() {
        return this.returnDescr;
    }

    public boolean isExceptionTag(String string) {
        String string2 = string;
        if (string.charAt(0) == '@') {
            string2 = string.substring(1);
        }
        return this.exceptionTag.equals(string2) || string2.equals("exception") || string2.equals("throws");
    }

    private boolean isDebug() {
        return this.debug;
    }

    public void reload() {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        try {
            this.setExceptionTag(fileSettings.getString("exception.tag.name"));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.setExceptionTag("exception");
        }
        try {
            this.setExceptionDescr(fileSettings.getString("exception.descr"));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.setExceptionDescr("Description of the exception");
        }
        try {
            this.setParamDescr(fileSettings.getString("param.descr"));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.setParamDescr("Description of the parameter");
        }
        try {
            this.setReturnDescr(fileSettings.getString("return.descr"));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.setReturnDescr("Description of the return value");
        }
        try {
            this.setConstructorDescr(fileSettings.getString("constructor.descr"));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.setConstructorDescr("Constructor for the {0} class");
        }
    }

    public static JavadocTags get() {
        if (singleton == null) {
            singleton = new JavadocTags();
            singleton.reload();
        }
        return singleton;
    }

    public String getConstructorDescr() {
        return this.constructorDescr;
    }

    public void setConstructorDescr(String string) {
        this.constructorDescr = string == null ? "" : string;
    }
}

