/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.StringTokenizer;
import org.acm.seguin.pretty.JavadocDescriptionPrinter;
import org.acm.seguin.pretty.PrintData;

public class JavaDocComponent {
    private String type = "";
    private String description = "";
    private int longestLength = 0;
    private boolean printed = false;
    private boolean required = false;

    public void setType(String string) {
        if (string != null) {
            this.type = string;
            this.setLongestLength(this.type.length() + 2);
        }
    }

    public void setDescription(String string) {
        if (string != null) {
            this.description = string;
        }
    }

    public void setLongestLength(int n) {
        this.longestLength = n;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLongestLength() {
        return this.longestLength;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void print(PrintData printData) {
        int n;
        this.setPrinted(true);
        if (!printData.isCurrentSingle()) {
            printData.indent();
            printData.appendComment(" *", 1);
        }
        if (printData.isSpaceBeforeAt() && !this.isDescription()) {
            printData.appendComment(" ", 1);
        }
        if (!this.isDescription()) {
            printData.appendComment(this.getType(), 1);
        }
        if (!this.isDescription() && printData.isJavadocLinedUp()) {
            n = this.getLongestLength() - this.getType().length();
            int n2 = 0;
            while (n2 < n) {
                printData.appendComment(" ", 1);
                ++n2;
            }
        }
        if (printData.isReformatComments() || !this.isDescription()) {
            n = 0;
            while (n < printData.getJavadocIndent()) {
                printData.appendComment(" ", 1);
                ++n;
            }
        }
        this.printDescription(printData);
        if (!printData.isCurrentSingle()) {
            printData.newline();
        }
    }

    protected void setPrinted(boolean bl) {
        this.printed = bl;
    }

    protected void printDescription(PrintData printData) {
        this.wordwrapDescription(printData, this.getType().length() == 0);
    }

    protected void wordwrapDescription(PrintData printData, boolean bl) {
        JavadocDescriptionPrinter javadocDescriptionPrinter = new JavadocDescriptionPrinter(printData, this.getDescription(), bl ? printData.getJavadocIndent() : 6);
        javadocDescriptionPrinter.run();
    }

    protected void leaveDescription(PrintData printData) {
        StringBuffer stringBuffer = new StringBuffer(printData.getJavadocIndent());
        int n = 0;
        while (n < printData.getJavadocIndent()) {
            stringBuffer.append(" ");
            ++n;
        }
        String string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getDescription(), "\n\r");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                printData.indent();
                printData.appendComment(" *", 1);
                printData.appendComment(string, 1);
            }
            printData.appendComment(string2, 1);
            bl = false;
        }
    }

    boolean isDescription() {
        return this.getType().length() == 0;
    }
}

