/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.FieldSize;

class FieldSizeLookAhead {
    private FieldSize fieldSize = new FieldSize();
    private int code;

    public FieldSizeLookAhead(int n) {
        this.code = n;
    }

    public FieldSize run(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n2);
            if (simpleNode2.jjtGetChild(0) instanceof ASTFieldDeclaration) {
                ASTFieldDeclaration aSTFieldDeclaration = (ASTFieldDeclaration)simpleNode2.jjtGetChild(0);
                if (this.code != 2 || !this.isJavadocAttached(aSTFieldDeclaration)) {
                    int n3 = this.computeEqualsLength(aSTFieldDeclaration);
                    this.fieldSize.setMinimumEquals(n3);
                }
            }
            ++n2;
        }
        return this.fieldSize;
    }

    public int computeEqualsLength(ASTFieldDeclaration aSTFieldDeclaration) {
        int n = this.computeModifierLength(aSTFieldDeclaration);
        int n2 = this.computeTypeLength(aSTFieldDeclaration);
        int n3 = this.computeNameLength(aSTFieldDeclaration);
        int n4 = n + n2 + n3;
        return n4;
    }

    public int computeTypeLength(ASTFieldDeclaration aSTFieldDeclaration) {
        ASTType aSTType = (ASTType)aSTFieldDeclaration.jjtGetChild(0);
        int n = 2 * aSTType.getArrayCount();
        if (aSTType.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType aSTPrimitiveType = (ASTPrimitiveType)aSTType.jjtGetChild(0);
            n += aSTPrimitiveType.getName().length();
        } else {
            ASTName aSTName = (ASTName)aSTType.jjtGetChild(0);
            n += aSTName.getName().length();
        }
        this.fieldSize.setTypeLength(n);
        return n;
    }

    private boolean isJavadocAttached(ASTFieldDeclaration aSTFieldDeclaration) {
        return this.hasJavadoc(aSTFieldDeclaration.getSpecial("static")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("transient")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("volatile")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("final")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("public")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("protected")) || this.hasJavadoc(aSTFieldDeclaration.getSpecial("private")) || this.hasJavadoc(this.getInitialToken((ASTType)aSTFieldDeclaration.jjtGetChild(0)));
    }

    private Token getInitialToken(ASTType aSTType) {
        if (aSTType.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType aSTPrimitiveType = (ASTPrimitiveType)aSTType.jjtGetChild(0);
            return aSTPrimitiveType.getSpecial("primitive");
        }
        ASTName aSTName = (ASTName)aSTType.jjtGetChild(0);
        return aSTName.getSpecial("id0");
    }

    private int computeNameLength(ASTFieldDeclaration aSTFieldDeclaration) {
        ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTFieldDeclaration.jjtGetChild(1).jjtGetChild(0);
        int n = aSTVariableDeclaratorId.getName().length();
        this.fieldSize.setNameLength(n);
        return n;
    }

    private int computeModifierLength(ASTFieldDeclaration aSTFieldDeclaration) {
        int n = aSTFieldDeclaration.getModifiersString().length();
        this.fieldSize.setModifierLength(n);
        return n;
    }

    private boolean hasJavadoc(Token token) {
        Token token2 = token;
        while (token2 != null) {
            if (token2.kind == 12) {
                return true;
            }
            token2 = token2.specialToken;
        }
        return false;
    }
}

