/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.text.NumberFormat;
import org.acm.seguin.metrics.GatherData;
import org.acm.seguin.metrics.MethodMetrics;
import org.acm.seguin.metrics.MetricsFrame;
import org.acm.seguin.metrics.TypeMetrics;
import org.acm.seguin.summary.MethodSummary;

public class MethodMetricsFrame
extends MetricsFrame {
    private MethodSummary method;
    private MethodMetrics metrics;

    public MethodMetricsFrame(MethodSummary methodSummary) {
        this.method = methodSummary;
        TypeMetrics typeMetrics = new TypeMetrics("-package-", "-type-");
        GatherData gatherData = new GatherData(null);
        this.metrics = (MethodMetrics)gatherData.visit(this.method, (Object)typeMetrics);
        this.descriptions = new String[]{"Description", "Statement Count", "Parameter Count"};
        this.values = new String[3];
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        this.values[0] = "Values";
        this.values[1] = "" + numberFormat.format(this.metrics.getStatementCount());
        this.values[2] = "" + numberFormat.format(this.metrics.getParameterCount());
        this.createFrame();
    }

    protected String getTitle() {
        return "Metrics for the method " + this.method.getName();
    }
}

