/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;

public abstract class DirectoryTreeTraversal {
    private File startingPoint;

    public DirectoryTreeTraversal(String string) {
        this.startingPoint = new File(string);
    }

    public void go() {
        if (this.startingPoint.exists()) {
            this.traverse(this.startingPoint);
        }
    }

    protected abstract boolean isTarget(File var1);

    protected boolean isAllowed(File file) {
        return true;
    }

    protected void traverse(File file) {
        if (file.isDirectory()) {
            if (this.isAllowed(file)) {
                this.arriveAtDir(file);
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    this.traverse(new File(file, stringArray[n]));
                    ++n;
                }
                this.leaveDir(file);
            }
        } else if (this.isTarget(file)) {
            this.visit(file);
        }
    }

    protected abstract void visit(File var1);

    protected void arriveAtDir(File file) {
    }

    protected void leaveDir(File file) {
    }
}

