/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.elixir.version;

import com.elixirtech.tree.TNode;
import java.io.File;
import javax.swing.JMenuItem;
import org.acm.seguin.ide.elixir.version.AddListener;
import org.acm.seguin.ide.elixir.version.CheckInListener;
import org.acm.seguin.ide.elixir.version.CheckOutListener;
import org.acm.seguin.ide.elixir.version.ElixirVersionControl;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.version.VersionControl;
import org.acm.seguin.version.VersionControlCache;

public class ElixirContainsThread
extends Thread {
    private VersionControl delegate;
    private ElixirVersionControl evc;
    private JMenuItem menu;
    private TNode parent;

    public ElixirContainsThread(JMenuItem jMenuItem, TNode tNode, VersionControl versionControl, ElixirVersionControl elixirVersionControl) {
        this.menu = jMenuItem;
        this.parent = tNode;
        this.delegate = versionControl;
        this.evc = elixirVersionControl;
    }

    private boolean isUnderSourceControl(String string) {
        if (string == null) {
            return false;
        }
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "vss");
            int n = 1;
            while (true) {
                String string2 = fileSettings.getString("extension." + n);
                System.out.println("\t\tComparing:  [" + string + "] to [" + string2 + "]");
                if (string.endsWith(string2)) {
                    System.out.println("\t\tFound it");
                    return true;
                }
                ++n;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            return false;
        }
    }

    private void add() {
        this.menu.setText("Add");
        this.menu.setEnabled(false);
        this.menu.addActionListener(new AddListener(this.evc, this.parent.getFullName(), this.parent.getName()));
    }

    private void checkIn() {
        VersionControlCache versionControlCache = VersionControlCache.getCache();
        String string = this.parent.getFullName();
        this.menu.setText("Check In");
        this.menu.setEnabled(versionControlCache.lookup(string) == 1);
        this.menu.addActionListener(new CheckInListener(this.evc, string, this.parent.getName()));
    }

    private void checkOut() {
        boolean bl = true;
        String string = this.parent.getFullName();
        VersionControlCache versionControlCache = VersionControlCache.getCache();
        if (versionControlCache.isInCache(string)) {
            bl = versionControlCache.lookup(string) == 2;
        } else {
            versionControlCache.add(string, 2);
        }
        this.menu.setText("Check Out");
        this.menu.setEnabled(bl);
        this.menu.addActionListener(new CheckOutListener(this.evc, string, this.parent.getName()));
    }

    public int contains(String string) {
        VersionControlCache versionControlCache = VersionControlCache.getCache();
        if (versionControlCache.isInCache(string)) {
            return versionControlCache.lookup(string);
        }
        boolean bl = this.delegate.contains(string);
        int n = bl ? 1 : 0;
        versionControlCache.add(string, n);
        return n;
    }

    public void run() {
        String string = this.parent.getName();
        if (!this.isUnderSourceControl(string)) {
            this.menu.setText("Not under source control");
            this.menu.setEnabled(false);
            return;
        }
        System.out.println("Full Name:  " + this.parent.getFullName());
        File file = new File(this.parent.getFullName());
        if (!file.canWrite()) {
            this.checkOut();
        } else if (this.contains(this.parent.getFullName()) == 0) {
            this.add();
        } else {
            this.checkIn();
        }
        this.menu.repaint();
    }
}

