/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.acm.seguin.ide.common.ExitOnCloseAdapter;
import org.acm.seguin.ide.common.IconPanel;
import org.acm.seguin.ide.common.JumpToTypeAdapter;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.ClassIcon;
import org.acm.seguin.uml.InterfaceIcon;
import org.acm.seguin.uml.UMLIcon;
import org.acm.seguin.uml.UMLPackage;

public class ClassListPanel
extends JPanel {
    private PackageSummary summary;
    private UMLPackage umlPackage;

    public ClassListPanel(PackageSummary packageSummary, UMLPackage uMLPackage) {
        this.summary = packageSummary;
        this.umlPackage = uMLPackage;
        this.umlPackage.setClassListPanel(this);
        this.init();
    }

    private void addTypeToPanel(TypeSummary typeSummary, GridBagConstraints gridBagConstraints, int n) {
        JumpToTypeAdapter jumpToTypeAdapter = new JumpToTypeAdapter(this.umlPackage, typeSummary);
        UMLIcon uMLIcon = typeSummary.isInterface() ? new InterfaceIcon(8, 8) : new ClassIcon(8, 8);
        IconPanel iconPanel = new IconPanel(uMLIcon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        this.add((Component)iconPanel, gridBagConstraints);
        iconPanel.addMouseListener(jumpToTypeAdapter);
        JLabel jLabel = new JLabel(typeSummary.getName(), 2);
        gridBagConstraints.gridx = 1;
        this.add((Component)jLabel, gridBagConstraints);
        jLabel.addMouseListener(jumpToTypeAdapter);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.summary == null ? new JLabel("Unknown") : new JLabel(this.summary.getName());
        jLabel.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        int n = 1;
        Iterator iterator = this.listTypes();
        while (iterator.hasNext()) {
            TypeSummary typeSummary = (TypeSummary)iterator.next();
            this.addTypeToPanel(typeSummary, gridBagConstraints, n);
            ++n;
        }
        this.repaint();
    }

    private Iterator listTypes() {
        TreeMap<String, TypeSummary> treeMap = new TreeMap<String, TypeSummary>();
        Iterator iterator = null;
        if (this.summary != null) {
            iterator = this.summary.getFileSummaries();
        }
        while (iterator != null && iterator.hasNext()) {
            FileSummary fileSummary = (FileSummary)iterator.next();
            Iterator iterator2 = fileSummary.getTypes();
            while (iterator2 != null && iterator2.hasNext()) {
                TypeSummary typeSummary = (TypeSummary)iterator2.next();
                treeMap.put(typeSummary.getName(), typeSummary);
            }
        }
        return treeMap.values().iterator();
    }

    public void load(PackageSummary packageSummary) {
        this.summary = packageSummary;
        this.removeAll();
        this.init();
    }

    public static void main(String[] stringArray) {
        new SummaryTraversal("c:\\temp\\download").go();
        JFrame jFrame = new JFrame("Class List");
        jFrame.getContentPane().add(new ClassListPanel(PackageSummary.getPackageSummary("java.lang"), null));
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
        jFrame.addWindowListener(new ExitOnCloseAdapter());
    }
}

