/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;

public class CommonsMultipartRequestHandler
implements MultipartRequestHandler {
    public static final long DEFAULT_SIZE_MAX = 0xFA00000L;
    public static final int DEFAULT_SIZE_THRESHOLD = 262144;
    protected static Log log;
    private Hashtable elementsAll;
    private Hashtable elementsFile;
    private Hashtable elementsText;
    private ActionMapping mapping;
    private ActionServlet servlet;
    static /* synthetic */ Class class$org$apache$struts$upload$CommonsMultipartRequestHandler;

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    public void handleRequest(HttpServletRequest request) throws ServletException {
        ApplicationConfig ac = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION");
        FileUpload upload = new FileUpload();
        upload.setSizeMax((int)this.getSizeMax(ac));
        upload.setSizeThreshold(this.getSizeThreshold(ac));
        upload.setRepositoryPath(this.getRepositoryPath(ac));
        this.elementsText = new Hashtable();
        this.elementsFile = new Hashtable();
        this.elementsAll = new Hashtable();
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            if (e.getMessage().endsWith("size exceeds allowed range")) {
                request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
                return;
            }
            log.error((Object)"Failed to parse multipart request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = (FileItem)iter.next();
            if (item.isFormField()) {
                this.addTextParameter(request, item);
                continue;
            }
            this.addFileParameter(request, item);
        }
    }

    public Hashtable getTextElements() {
        return this.elementsText;
    }

    public Hashtable getFileElements() {
        return this.elementsFile;
    }

    public Hashtable getAllElements() {
        return this.elementsAll;
    }

    public void rollback() {
        Iterator iter = this.elementsFile.values().iterator();
        while (iter.hasNext()) {
            FormFile formFile = (FormFile)iter.next();
            formFile.destroy();
        }
    }

    public void finish() {
        this.rollback();
    }

    protected long getSizeMax(ApplicationConfig ac) {
        String sizeString = ac.getControllerConfig().getMaxFileSize();
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            multiplier = 0x40000000;
        }
        if (multiplier != 1) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
        }
        long size = 0L;
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid format for maximum file size ('" + ac.getControllerConfig().getMaxFileSize() + "'). Using default."));
            size = 0xFA00000L;
            multiplier = 1;
        }
        return size * (long)multiplier;
    }

    protected int getSizeThreshold(ApplicationConfig ac) {
        return 262144;
    }

    protected String getRepositoryPath(ApplicationConfig ac) {
        String tempDir = ac.getControllerConfig().getTempDir();
        if (tempDir == null || tempDir.length() == 0) {
            if (this.servlet != null) {
                ServletContext context = this.servlet.getServletContext();
                File tempDirFile = (File)context.getAttribute("javax.servlet.context.tempdir");
                tempDir = tempDirFile.getAbsolutePath();
            }
            if (tempDir == null || tempDir.length() == 0) {
                tempDir = System.getProperty("java.io.tmpdir");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("File upload temp dir: " + tempDir));
        }
        return tempDir;
    }

    protected void addTextParameter(HttpServletRequest request, FileItem item) {
        String[] newArray;
        String[] oldArray;
        String name = item.getFieldName();
        String value = item.getString();
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            wrapper.setParameter(name, value);
        }
        if ((oldArray = (String[])this.elementsText.get(name)) != null) {
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.elementsText.put(name, newArray);
        this.elementsAll.put(name, newArray);
    }

    protected void addFileParameter(HttpServletRequest request, FileItem item) {
        CommonsFormFile formFile = new CommonsFormFile(item);
        this.elementsFile.put(item.getFieldName(), formFile);
        this.elementsAll.put(item.getFieldName(), formFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_SIZE_MAX = 0xFA00000L;
        DEFAULT_SIZE_THRESHOLD = 262144;
        log = LogFactory.getLog((Class)(class$org$apache$struts$upload$CommonsMultipartRequestHandler == null ? (class$org$apache$struts$upload$CommonsMultipartRequestHandler = CommonsMultipartRequestHandler.class$("org.apache.struts.upload.CommonsMultipartRequestHandler")) : class$org$apache$struts$upload$CommonsMultipartRequestHandler));
    }

    static class CommonsFormFile
    implements FormFile {
        FileItem fileItem;

        public CommonsFormFile(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public void setContentType(String contentType) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        public int getFileSize() {
            return (int)this.fileItem.getSize();
        }

        public void setFileSize(int filesize) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        public void setFileName(String fileName) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        public void destroy() {
            this.fileItem.delete();
        }

        protected String getBaseFileName(String filePath) {
            String fileName = new File(filePath).getName();
            int colonIndex = fileName.indexOf(":");
            if (colonIndex == -1) {
                colonIndex = fileName.indexOf("\\\\");
            }
            int backslashIndex = fileName.lastIndexOf("\\");
            if (colonIndex > -1 && backslashIndex > -1) {
                fileName = fileName.substring(backslashIndex + 1);
            }
            return fileName;
        }
    }
}

