/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import javax.swing.JCheckBox;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;

class TypeCheckbox
extends JCheckBox {
    private TypeSummary type;

    public TypeCheckbox(TypeSummary typeSummary) {
        super(" ");
        this.type = typeSummary;
        this.setText(this.getFullName());
        this.setSize(this.getPreferredSize());
        this.setSelected(true);
    }

    public TypeSummary getTypeSummary() {
        return this.type;
    }

    String getFullName() {
        StringBuffer stringBuffer = new StringBuffer(this.type.getName());
        Summary summary = this.type.getParent();
        while (summary != null) {
            String string;
            if (summary instanceof TypeSummary) {
                stringBuffer.insert(0, ".");
                stringBuffer.insert(0, ((TypeSummary)summary).getName());
            } else if (summary instanceof PackageSummary && (string = ((PackageSummary)summary).getName()) != null && string.length() > 0) {
                stringBuffer.insert(0, ".");
                stringBuffer.insert(0, string);
            }
            summary = summary.getParent();
        }
        return stringBuffer.toString();
    }
}

