/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.acm.seguin.awt.CenterDialog;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.AddChildRefactoring;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetPackageSummary;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.refactor.ClassNameDialog;
import org.acm.seguin.uml.refactor.PackageList;

public class AddChildClassDialog
extends ClassNameDialog {
    private TypeSummary typeSummary;
    private JComboBox packageNameBox;

    public AddChildClassDialog(UMLPackage uMLPackage, TypeSummary typeSummary) {
        super(uMLPackage, 2);
        PackageList packageList = new PackageList();
        this.packageNameBox = packageList.add(this);
        String string = uMLPackage == null ? GetPackageSummary.query(typeSummary).getName() : uMLPackage.getSummary().getName();
        this.packageNameBox.setSelectedItem(string);
        this.typeSummary = typeSummary;
        this.pack();
        CenterDialog.center((JDialog)this, uMLPackage);
    }

    public String getWindowTitle() {
        return "Add a child class";
    }

    public String getLabelText() {
        return "Child class:";
    }

    protected Refactoring createRefactoring() {
        AddChildRefactoring addChildRefactoring = RefactoringFactory.get().addChild();
        addChildRefactoring.setChildName(this.getClassName());
        addChildRefactoring.setParentClass(this.typeSummary);
        addChildRefactoring.setPackageName((String)this.packageNameBox.getSelectedItem());
        return addChildRefactoring;
    }
}

