/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.print;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.print.UMLPagePrinter;

public class PrintingThread
extends Thread {
    private UMLPackage currentPackage;

    public PrintingThread(UMLPackage uMLPackage) {
        this.currentPackage = uMLPackage;
    }

    public void run() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        UMLPagePrinter uMLPagePrinter = new UMLPagePrinter(this.currentPackage);
        PageFormat pageFormat = UMLPagePrinter.getPageFormat(false);
        if (pageFormat == null) {
            pageFormat = UMLPagePrinter.getPageFormat(true);
        }
        int n = uMLPagePrinter.calculatePageCount(pageFormat);
        book.append(uMLPagePrinter, pageFormat, n);
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Throwable throwable) {
                ExceptionPrinter.print(throwable, false);
            }
        }
    }
}

