/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.acm.seguin.uml.line.LabelSizeComputation;
import org.acm.seguin.uml.line.ScalablePanel;
import org.acm.seguin.uml.line.TextInfo;

public class SizableLabel
extends ScalablePanel {
    private boolean bufferCreated = false;
    private Image scaledImage;
    private Color foreground;
    private Color background;
    private Font font;
    private int height = 200;
    private int width = 25;
    private String text;
    private int align;
    private int ascent;
    private static Font defaultFont = null;
    private static Color defaultColor = null;

    public SizableLabel() {
        this(" ");
    }

    public SizableLabel(String string) {
        if (defaultFont == null) {
            SizableLabel.init();
        }
        this.font = defaultFont;
        this.foreground = defaultColor;
        this.setText(string);
        this.setSize(this.getPreferredSize());
        this.setDoubleBuffered(false);
    }

    public void setSLForeground(Color color) {
        this.foreground = color;
        this.bufferCreated = false;
    }

    public void setSLFont(Font font) {
        this.font = font;
        this.setSize(this.getPreferredSize());
    }

    public void setText(String string) {
        this.text = string == null || string == "" ? " " : string;
        this.bufferCreated = false;
        this.setSize(this.getPreferredSize());
    }

    public void setSLHorizontalAlignment(int n) {
        this.align = n;
    }

    public String getText() {
        return this.text;
    }

    public Dimension getPreferredSize() {
        this.determineSize();
        Dimension dimension = new Dimension();
        dimension.width = this.scaleInteger(this.width);
        dimension.height = this.scaleInteger(this.height);
        this.bufferCreated = false;
        return dimension;
    }

    public void paint(Graphics graphics) {
        this.print(graphics, 0, 0);
    }

    public void print(Graphics graphics, int n, int n2) {
        if (!this.bufferCreated || !this.getParentBackground().equals(this.background)) {
            this.createBuffer();
        }
        Dimension dimension = this.getSize();
        if (this.align == 2) {
            graphics.drawImage(this.scaledImage, n, n2, this);
        } else if (this.align == 4) {
            int n3 = dimension.width - this.scaleInteger(this.width);
            graphics.drawImage(this.scaledImage, n + n3, n2, this);
        } else if (this.align == 0) {
            int n4 = (int)((double)(dimension.width - this.scaleInteger(this.width)) * 0.5);
            graphics.drawImage(this.scaledImage, n + n4, n2, this);
        }
    }

    public void scale(double d) {
        if (Math.abs(this.getScale() - d) > 0.001) {
            super.scale(d);
            this.bufferCreated = false;
        }
    }

    private Color getParentBackground() {
        Container container = this.getParent();
        if (container == null) {
            return Color.gray;
        }
        return container.getBackground();
    }

    private void createBuffer() {
        this.bufferCreated = true;
        this.determineSize();
        Dimension dimension = new Dimension(this.width, this.height);
        int n = Math.max(1, this.scaleInteger(this.width + 10));
        int n2 = Math.max(1, this.scaleInteger(this.height + 10));
        this.scaledImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)this.scaledImage.getGraphics();
        graphics2D.scale(this.getScale(), this.getScale());
        this.background = this.getParentBackground();
        graphics2D.setColor(this.background);
        graphics2D.fillRect(0, 0, dimension.width + 10, dimension.height + 10);
        graphics2D.setColor(this.foreground);
        graphics2D.setFont(this.font);
        graphics2D.drawString(this.text, 0, this.ascent);
    }

    private void determineSize() {
        TextInfo textInfo = LabelSizeComputation.get().compute(this.text, this.font);
        this.height = textInfo.height;
        this.width = textInfo.width;
        this.ascent = textInfo.ascent;
    }

    private void debug() {
        System.out.println("Label:  " + this.text);
        System.out.println("    Scale:  " + this.getScale());
        System.out.println("    Height:  " + this.height);
        System.out.println("    Width:   " + this.width);
        System.out.println("    Align:   " + this.align);
        System.out.println("    Color:   " + this.foreground);
        System.out.println("    Shape:   " + this.getBounds());
    }

    private static synchronized void init() {
        if (defaultFont == null) {
            defaultFont = new Font("Serif", 0, 12);
            defaultColor = new Color(0, 80, 180);
        }
    }
}

